/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process.util.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bonitasoft.bpm.model.configuration.ConfigurationPackage;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorConfigurationPackage;
import org.bonitasoft.bpm.model.process.Messages;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.bonitasoft.bpm.model.process.util.migration.HistoryUtils;
import org.bonitasoft.bpm.model.process.util.migration.InputStreamSupplier;
import org.bonitasoft.bpm.model.process.util.migration.LenientResourceMigrator;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.bpm.model.process.util.migration.MigrationResult;
import org.bonitasoft.bpm.model.process.util.migration.SingleResourceMigrator;
import org.bonitasoft.bpm.model.util.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.MigratorRegistry;
import org.eclipse.emf.edapt.spi.history.Release;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MigrationHelper
extends AdapterImpl {
    public static final String OPTION_MIGRATION_POLICY = "MIGRATION_POLICY";
    private Optional<? extends Exception> storedParseException = Optional.empty();
    private ContentHandler informationHandler;
    private IStatus modelVersionStatus;

    public static MigrationHelper getHelper(Resource emfResource, InputStreamSupplier streamSupplier) throws IOException, SAXException, ParserConfigurationException {
        return emfResource.eAdapters().stream().filter(MigrationHelper.class::isInstance).map(MigrationHelper.class::cast).findFirst().orElseGet(() -> {
            MigrationHelper helper = new MigrationHelper(emfResource, streamSupplier);
            emfResource.eAdapters().add((Object)helper);
            return helper;
        }).orThrowParseException();
    }

    private MigrationHelper(Resource resource, InputStreamSupplier streamSupplier) {
        this.parseForInformation(streamSupplier);
        this.modelVersionStatus = this.compareModelVersions(resource.getURI().lastSegment());
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeatureID(Resource.class) == 4 && !msg.getNewBooleanValue()) {
            Resource resource = (Resource)msg.getNotifier();
            resource.eAdapters().remove((Object)this);
        }
    }

    public void setTarget(Notifier newTarget) {
        if (!(newTarget == null || this.target == null && newTarget instanceof Resource)) {
            throw new IllegalArgumentException();
        }
        super.setTarget(newTarget);
    }

    public Resource getTarget() {
        return (Resource)super.getTarget();
    }

    private IStatus compareModelVersions(String filename) {
        String modelVersion = this.getModelVersion();
        if (modelVersion == null || !HistoryUtils.IS_KNOWN_VERSION.test(modelVersion)) {
            return Status.error((String)String.format(Messages.incompatibleModelVersion, filename));
        }
        DefaultArtifactVersion version = new DefaultArtifactVersion(modelVersion);
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(HistoryUtils.CURRENT_MODEL_VERSION);
        switch (Integer.signum(currentVersion.compareTo((Object)version))) {
            case 0: {
                return Status.OK_STATUS;
            }
            case 1: {
                return Status.warning((String)String.format(Messages.migrationWillBreakRetroCompatibility, filename));
            }
        }
        return Status.error((String)String.format(Messages.incompatibleModelVersion, filename));
    }

    private MigrationHelper orThrowParseException() throws IOException, SAXException, ParserConfigurationException {
        Optional<IOException> io = this.storedParseException.filter(IOException.class::isInstance).map(IOException.class::cast);
        Optional<SAXException> sax = this.storedParseException.filter(SAXException.class::isInstance).map(SAXException.class::cast);
        Optional<ParserConfigurationException> conf = this.storedParseException.filter(ParserConfigurationException.class::isInstance).map(ParserConfigurationException.class::cast);
        if (io.isPresent()) {
            throw io.get();
        }
        if (sax.isPresent()) {
            throw sax.get();
        }
        if (conf.isPresent()) {
            throw conf.get();
        }
        return this;
    }

    private void parseForInformation(InputStreamSupplier streamSupplier) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream newStream = streamSupplier.get();){
                ContentHandler contentHandler = new ContentHandler();
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                parserFactory.setNamespaceAware(true);
                XMLReader reader = parserFactory.newSAXParser().getXMLReader();
                reader.setContentHandler(contentHandler);
                this.doParseForInformation(newStream, contentHandler, reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            this.storedParseException = Optional.of(exception);
        }
    }

    private void doParseForInformation(InputStream newStream, ContentHandler contentHandler, XMLReader reader) throws IOException {
        try {
            this.informationHandler = contentHandler;
            reader.parse(new InputSource(newStream));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Migrator getMigrator(String nsURI) {
        SingleResourceMigrator singleMigrator = SingleResourceMigrator.getInstance();
        if (!singleMigrator.getNsURIs().contains(nsURI)) {
            Migrator registeredMigrator = MigratorRegistry.getInstance().getMigrator(nsURI);
            if (registeredMigrator != null) {
                return new LenientResourceMigrator(registeredMigrator);
            }
            return null;
        }
        return singleMigrator;
    }

    public String getNsURI() {
        return Optional.ofNullable(this.informationHandler).map(c -> c.nsURI).orElse(null);
    }

    public List<String> getAllNamespaceUris() {
        return Optional.ofNullable(this.informationHandler).map(c -> c.allNsURIs).orElseGet(Collections::emptyList);
    }

    public String getModelVersion() {
        return Optional.ofNullable(this.informationHandler).map(c -> c.modelVersion).orElse(null);
    }

    public IStatus getModelVersionStatus() {
        return this.modelVersionStatus;
    }

    public MigrationResult tryAndMigrate(MigrationPolicy migrationPolicy, Map<?, ?> defaultLoadOptions, Map<?, ?> defaultSaveOptions) throws MigrationException {
        if (this.modelVersionStatus.getSeverity() == 2) {
            URI uri = this.getTarget().getURI();
            boolean isReadOnly = Boolean.TRUE.equals(this.getTarget().getResourceSet().getURIConverter().getAttributes(uri, Map.of("readOnly", true)).get("readOnly"));
            String name = uri.lastSegment();
            MigrationResult desiredResult = migrationPolicy.decideMigration(this.modelVersionStatus, name, isReadOnly);
            boolean hasActuallyMigrated = false;
            if (desiredResult.doMigrate()) {
                Optional<Release> release;
                String modelVersion = this.getModelVersion();
                String nsUri = this.getNsURI();
                Migrator actualMigrator = this.getMigrator(nsUri);
                Map<Release, Migrator> extraMigrators = this.collectExtraMigrators(actualMigrator);
                HashMap loadOptions = new HashMap(defaultLoadOptions);
                HashMap<String, Object> saveOptions = new HashMap<String, Object>();
                defaultSaveOptions.forEach((k, v) -> {
                    Object object = saveOptions.put(k.toString(), v);
                });
                if (!extraMigrators.isEmpty()) {
                    loadOptions.putAll(Map.of("EXTENDED_META_DATA", Boolean.TRUE, "RECORD_UNKNOWN_FEATURE", Boolean.TRUE));
                    saveOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                }
                if ((release = actualMigrator.getReleases().stream().filter(r -> r.getLabel().equals(modelVersion)).findFirst()).filter(r -> !r.isLastRelease()).isPresent()) {
                    hasActuallyMigrated = this.performMigration(loadOptions, saveOptions, uri, desiredResult, actualMigrator, release.get(), false);
                }
                for (Map.Entry<Release, Migrator> entry : extraMigrators.entrySet()) {
                    Release currentRelease = entry.getKey();
                    Migrator extraMigrator = entry.getValue();
                    hasActuallyMigrated = this.performMigration(loadOptions, saveOptions, uri, desiredResult, extraMigrator, currentRelease, hasActuallyMigrated && !desiredResult.doEraseResource());
                }
            }
            if (hasActuallyMigrated) {
                return desiredResult;
            }
        }
        return MigrationResult.NO_MIGRATION;
    }

    private Map<Release, Migrator> collectExtraMigrators(Migrator mainMigrator) {
        String nsUri = this.getNsURI();
        List<String> allNamespaceUris = this.getAllNamespaceUris();
        HashMap<Release, Migrator> extraMigrators = new HashMap<Release, Migrator>();
        for (String extraNsUri : allNamespaceUris) {
            Optional<Release> currentRelease;
            Migrator extraMigrator;
            if (nsUri.equals(extraNsUri) || (extraMigrator = this.getMigrator(extraNsUri)) == null || mainMigrator.equals(extraMigrator) || !(currentRelease = extraMigrator.getReleases().stream().filter(r -> extraNsUri.endsWith("/" + r.getLabel())).findFirst()).filter(r -> !r.isLatestRelease()).isPresent()) continue;
            extraMigrators.put(currentRelease.get(), extraMigrator);
        }
        return extraMigrators;
    }

    private boolean performMigration(Map<?, ?> loadOptions, Map<String, Object> saveOptions, URI uri, MigrationResult desiredResult, Migrator migrator, Release release, boolean reuseResource) throws MigrationException {
        migrator.setLevel(ValidationLevel.RELEASE);
        IResourceSetFactory rsetFactory = () -> {
            ResourceSetImpl set = reuseResource ? new ResourceSetLoadingFromTarget(saveOptions) : new ResourceSetImpl();
            set.getLoadOptions().putAll(loadOptions);
            set.getLoadOptions().remove(OPTION_MIGRATION_POLICY);
            return set;
        };
        migrator.setResourceSetFactory(rsetFactory);
        try {
            if (desiredResult.doEraseResource()) {
                migrator.migrateAndSave(Collections.singletonList(uri), release, null, (IProgressMonitor)new NullProgressMonitor(), saveOptions);
            } else {
                ResourceSet resourceSet = migrator.migrateAndLoad(Collections.singletonList(uri), release, null, (IProgressMonitor)new NullProgressMonitor());
                resourceSet.getLoadOptions().putAll(loadOptions);
                resourceSet.getLoadOptions().remove(OPTION_MIGRATION_POLICY);
                EList contents = ((Resource)resourceSet.getResources().get(0)).getContents();
                this.getTarget().getContents().clear();
                this.getTarget().getContents().addAll((Collection)contents);
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new MigrationException(String.format("Failed to migrate %s", uri), (Throwable)e);
        }
    }

    private static class ContentHandler
    extends DefaultHandler {
        private static final String VERY_FIRST_VERSION = "6.0.0-Alpha";
        private String nsURI;
        private List<String> allNsURIs = new ArrayList<String>();
        private String modelVersion;

        private ContentHandler() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.allNsURIs.add(uri);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"http://www.omg.org/XMI".equals(uri) && !"http://www.w3.org/2001/XMLSchema".equals(uri)) {
                this.nsURI = uri;
                if (qName.endsWith(":" + ProcessPackage.Literals.MAIN_PROCESS.getName())) {
                    String modelVersionAtt = attributes.getValue(ProcessPackage.Literals.MAIN_PROCESS__BONITA_MODEL_VERSION.getName());
                    this.setModelVersion(modelVersionAtt);
                } else if (qName.endsWith(":" + ConfigurationPackage.Literals.CONFIGURATION.getName())) {
                    String modelVersionAtt = attributes.getValue(ConfigurationPackage.Literals.CONFIGURATION__VERSION.getName());
                    this.setModelVersion(modelVersionAtt);
                } else if (qName.endsWith(":" + ConnectorConfigurationPackage.Literals.CONNECTOR_CONFIGURATION.getName())) {
                    String modelVersionAtt = attributes.getValue(ConnectorConfigurationPackage.Literals.CONNECTOR_CONFIGURATION__MODEL_VERSION.getName());
                    this.setModelVersion(modelVersionAtt);
                }
                throw new SAXException();
            }
        }

        private void setModelVersion(String modelVersionAtt) {
            this.modelVersion = Optional.ofNullable(modelVersionAtt).filter(v -> !VERY_FIRST_VERSION.startsWith((String)v)).orElse(VERY_FIRST_VERSION);
        }
    }

    private final class ResourceSetLoadingFromTarget
    extends ResourceSetImpl {
        private final Map<?, ?> saveOptions;

        private ResourceSetLoadingFromTarget(Map<?, ?> saveOptions) {
            this.saveOptions = saveOptions;
        }

        protected void demandLoad(Resource resource) throws IOException {
            URI uri = resource.getURI();
            if (uri.equals(MigrationHelper.this.getTarget().getURI())) {
                FileUtil.withTempFile(uri.lastSegment(), path -> {
                    Object var5_8;
                    Throwable throwable;
                    File temp = path.toFile();
                    try {
                        throwable = null;
                        var5_8 = null;
                        try (FileOutputStream out = new FileOutputStream(temp);){
                            MigrationHelper.this.getTarget().save((OutputStream)out, this.saveOptions);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        this.handleDemandLoadException(resource, e);
                        return;
                    }
                    throwable = null;
                    var5_8 = null;
                    try (FileInputStream in = new FileInputStream(temp);){
                        resource.load((InputStream)in, this.getLoadOptions());
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                });
            } else {
                super.demandLoad(resource);
            }
        }
    }
}

