/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process.util.migration;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bonitasoft.bpm.model.process.util.migration.HistoryUtils;
import org.bonitasoft.bpm.model.process.util.migration.LenientResourceMigrator;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edapt.common.IResourceSetProcessor;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.internal.BundleClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.internal.ClassLoaderFacade;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.osgi.framework.Bundle;

public class SingleResourceMigrator
extends LenientResourceMigrator {
    private static final IResourceSetProcessor POST_LOAD_PROCESSOR = rset -> {
        Resource r = (Resource)rset.getResources().get(0);
        if (r instanceof XMLResource) {
            Map extMap = ((XMLResource)r).getEObjectToExtensionMap();
            List<Runnable> operations = extMap.entrySet().stream().flatMap(entry -> {
                EObject obj = (EObject)entry.getKey();
                FeatureMap featMap = ((AnyType)entry.getValue()).getMixed();
                return featMap.stream().map(featEntry -> {
                    EStructuralFeature feat = obj.eClass().getEStructuralFeature(featEntry.getEStructuralFeature().getName());
                    Object val = featEntry.getValue();
                    if (feat.getEType().isInstance(val)) {
                        Runnable run = feat instanceof EReference && ((EReference)feat).isContainer() ? null : (feat.isMany() ? () -> {
                            boolean bl = ((List)obj.eGet(feat)).add(val);
                        } : () -> obj.eSet(feat, val));
                        return run;
                    }
                    String msg = MessageFormat.format("Model was built with unknown elements in a specific feature. Value {0} can not be inserted in feature {1} of {2}", val, feat.getName(), obj);
                    throw new IllegalStateException(msg);
                }).filter(Objects::nonNull);
            }).collect(Collectors.toList());
            operations.forEach(Runnable::run);
        }
    };
    private static SingleResourceMigrator instance;

    public static SingleResourceMigrator getInstance() {
        if (instance == null) {
            try {
                instance = new SingleResourceMigrator();
            }
            catch (MigrationException e) {
                throw new IllegalArgumentException();
            }
        }
        return instance;
    }

    private SingleResourceMigrator() throws MigrationException {
        super(HistoryUtils.getMigrationHistoryURI(), SingleResourceMigrator.getMigrationClassLoader());
        this.setPostLoadModelProcessor(POST_LOAD_PROCESSOR);
    }

    private static IClassLoader getMigrationClassLoader() {
        Bundle bundle;
        if (EnvironmentUtil.isOSGi() && (bundle = Platform.getBundle((String)"org.bonitasoft.bpm.migration")) != null) {
            return new BundleClassLoader(bundle);
        }
        ClassLoader classLoader = SingleResourceMigrator.class.getClassLoader();
        try {
            classLoader.loadClass("org.bonitasoft.bpm.migration.custom.migration.BusinessObjectTypeCustomMigration");
        }
        catch (ClassNotFoundException e) {
            EcorePlugin.INSTANCE.log((Object)"Library org.bonitasoft.bpm.migration not found for migration");
        }
        return new ClassLoaderFacade(classLoader);
    }
}

