/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class FileUtil {
    private static final String USER_ONLY_PERMISSIONS = "rwx------";

    private FileUtil() {
    }

    public static void deleteDir(Path directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> pathStream = Files.walk(directory, new FileVisitOption[0]);){
            pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Path createTempDir(String prefix) throws IOException {
        if (EnvironmentUtil.isWindows()) {
            Path dir = Files.createTempDirectory(prefix, new FileAttribute[0]);
            FileUtil.setWindowsPermissions(dir);
            return dir;
        }
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(USER_ONLY_PERMISSIONS));
        return Files.createTempDirectory(prefix, attr);
    }

    public static void withTempDir(String prefix, FileConsumer operation) throws IOException {
        Objects.requireNonNull(operation);
        Path dir = FileUtil.createTempDir(prefix);
        try {
            operation.accept(dir);
        }
        finally {
            FileUtil.deleteDir(dir);
        }
    }

    public static Path createTempFile(String baseFileName) throws IOException {
        String suffix;
        String prefix;
        int dotIndex = baseFileName.lastIndexOf(46);
        if (dotIndex > 0) {
            prefix = baseFileName.substring(0, dotIndex);
            suffix = baseFileName.substring(dotIndex);
        } else {
            prefix = baseFileName;
            suffix = null;
        }
        return FileUtil.createTempFile(prefix, suffix);
    }

    public static Path createTempFile(String prefix, String suffix) throws IOException {
        if (EnvironmentUtil.isWindows()) {
            Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
            FileUtil.setWindowsPermissions(path);
            return path;
        }
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(USER_ONLY_PERMISSIONS));
        return Files.createTempFile(prefix, suffix, attr);
    }

    public static void withTempFile(String prefix, String suffix, FileConsumer operation) throws IOException {
        Objects.requireNonNull(operation);
        Path file = FileUtil.createTempFile(prefix, suffix);
        try {
            operation.accept(file);
        }
        finally {
            Files.deleteIfExists(file);
        }
    }

    public static void withTempFile(String baseFileName, FileConsumer operation) throws IOException {
        Objects.requireNonNull(operation);
        Path file = FileUtil.createTempFile(baseFileName);
        try {
            operation.accept(file);
        }
        finally {
            Files.deleteIfExists(file);
        }
    }

    private static void setWindowsPermissions(Path path) {
        File file = path.toFile();
        boolean permOk = file.setReadable(true, true);
        permOk = file.setWritable(true, true) && permOk;
        boolean bl = permOk = file.setExecutable(true, true) && permOk;
        if (!permOk) {
            EcorePlugin.INSTANCE.log((Object)MessageFormat.format("Permission could not be set for file {0}", path));
        }
    }

    @FunctionalInterface
    public static interface FileConsumer {
        public void accept(Path var1) throws IOException;

        default public FileConsumer andThen(FileConsumer after) {
            Objects.requireNonNull(after);
            return f -> {
                this.accept(f);
                after.accept(f);
            };
        }
    }
}

