/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.form;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LabelPosition implements Enumerator
{
    LEFT(0, "Left", "Left"),
    RIGHT(1, "Right", "Right"),
    UP(2, "Up", "Up"),
    DOWN(3, "Down", "Down");

    public static final int LEFT_VALUE = 0;
    public static final int RIGHT_VALUE = 1;
    public static final int UP_VALUE = 2;
    public static final int DOWN_VALUE = 3;
    private static final LabelPosition[] VALUES_ARRAY;
    public static final List<LabelPosition> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LabelPosition[]{LEFT, RIGHT, UP, DOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LabelPosition get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LabelPosition result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LabelPosition getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LabelPosition result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LabelPosition get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return RIGHT;
            }
            case 2: {
                return UP;
            }
            case 3: {
                return DOWN;
            }
        }
        return null;
    }

    private LabelPosition(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

