/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.bonitasoft.bpm.model.process.util.migration.InputStreamSupplier;
import org.bonitasoft.bpm.model.process.util.migration.MigrationHelper;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.bpm.model.process.util.migration.MigrationResult;
import org.bonitasoft.bpm.model.util.internal.DuplicatingInputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.xml.sax.SAXException;

public class MigratingXMLResource
extends XMLResourceImpl {
    public static final String OPTION_MIGRATION_POLICY = "MIGRATION_POLICY";
    private MigrationPolicy migrationPolicy = MigrationPolicy.NEVER_MIGRATE_POLICY;

    public MigratingXMLResource(URI uri) {
        super(uri);
        this.getDefaultLoadOptions();
        this.getDefaultSaveOptions();
    }

    public void setMigrationPolicy(MigrationPolicy migrationPolicy) {
        this.migrationPolicy = migrationPolicy;
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        block23: {
            Object extendedMetadataOption;
            Object optionValue;
            if (options.containsKey(OPTION_MIGRATION_POLICY) && (optionValue = options.get(OPTION_MIGRATION_POLICY)) instanceof MigrationPolicy) {
                this.setMigrationPolicy((MigrationPolicy)optionValue);
            }
            if ((extendedMetadataOption = options.get("EXTENDED_META_DATA")) != null) {
                this.getDefaultSaveOptions().putIfAbsent("EXTENDED_META_DATA", extendedMetadataOption);
            }
            if (this.getURIConverter().exists(this.uri, options)) {
                InputStreamSupplier streamSupplier = () -> this.getURIConverter().createInputStream(this.uri, options);
                MigrationResult result = this.checkMigration(streamSupplier, options);
                if (!MigrationResult.SOFT_MIGRATION.equals((Object)result)) {
                    super.doLoad(inputStream, options);
                }
            } else {
                Throwable throwable = null;
                Object var5_8 = null;
                try (DuplicatingInputStream buffered = new DuplicatingInputStream(inputStream);){
                    InputStreamSupplier streamSupplier = buffered::getNonClosingStreamCopy;
                    MigrationResult result = this.checkMigration(streamSupplier, options);
                    if (MigrationResult.SOFT_MIGRATION.equals((Object)result)) break block23;
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (InputStream streamForSuper = buffered.getClosingMasterStreamCopy();){
                        super.doLoad(streamForSuper, options);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected MigrationResult checkMigration(InputStreamSupplier streamSupplier, Map<?, ?> options) throws IOException {
        try {
            MigrationHelper migration = MigrationHelper.getHelper((Resource)this, streamSupplier);
            if (migration.getModelVersionStatus().getSeverity() == 2) {
                return migration.tryAndMigrate(this.migrationPolicy, options, this.getDefaultSaveOptions());
            }
        }
        catch (ParserConfigurationException | MigrationException | SAXException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw new IOException(exception);
        }
        catch (IOException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw exception;
        }
        return MigrationResult.NO_MIGRATION;
    }
}

