/**
 * Copyright (C) 2009-2022 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2.0 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.bonitasoft.bpm.model.form.impl;

import org.bonitasoft.bpm.model.form.FormPackage;
import org.bonitasoft.bpm.model.form.TextAreaFormField;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Text Area Form Field</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.bonitasoft.bpm.model.form.impl.TextAreaFormFieldImpl#getMaxLength <em>Max Length</em>}</li>
 *   <li>{@link org.bonitasoft.bpm.model.form.impl.TextAreaFormFieldImpl#getMaxHeigth <em>Max Heigth</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TextAreaFormFieldImpl extends SingleValuatedFormFieldImpl implements TextAreaFormField {
    /**
     * The default value of the '{@link #getMaxLength() <em>Max Length</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMaxLength()
     * @generated
     * @ordered
     */
    protected static final int MAX_LENGTH_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getMaxLength() <em>Max Length</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMaxLength()
     * @generated
     * @ordered
     */
    protected int maxLength = MAX_LENGTH_EDEFAULT;

    /**
     * The default value of the '{@link #getMaxHeigth() <em>Max Heigth</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMaxHeigth()
     * @generated
     * @ordered
     */
    protected static final int MAX_HEIGTH_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getMaxHeigth() <em>Max Heigth</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMaxHeigth()
     * @generated
     * @ordered
     */
    protected int maxHeigth = MAX_HEIGTH_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TextAreaFormFieldImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return FormPackage.Literals.TEXT_AREA_FORM_FIELD;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int getMaxLength() {
        return maxLength;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMaxLength(int newMaxLength) {
        int oldMaxLength = maxLength;
        maxLength = newMaxLength;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, FormPackage.TEXT_AREA_FORM_FIELD__MAX_LENGTH, oldMaxLength, maxLength));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int getMaxHeigth() {
        return maxHeigth;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMaxHeigth(int newMaxHeigth) {
        int oldMaxHeigth = maxHeigth;
        maxHeigth = newMaxHeigth;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, FormPackage.TEXT_AREA_FORM_FIELD__MAX_HEIGTH, oldMaxHeigth, maxHeigth));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_LENGTH:
                return getMaxLength();
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_HEIGTH:
                return getMaxHeigth();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_LENGTH:
                setMaxLength((Integer)newValue);
                return;
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_HEIGTH:
                setMaxHeigth((Integer)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_LENGTH:
                setMaxLength(MAX_LENGTH_EDEFAULT);
                return;
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_HEIGTH:
                setMaxHeigth(MAX_HEIGTH_EDEFAULT);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_LENGTH:
                return maxLength != MAX_LENGTH_EDEFAULT;
            case FormPackage.TEXT_AREA_FORM_FIELD__MAX_HEIGTH:
                return maxHeigth != MAX_HEIGTH_EDEFAULT;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (maxLength: "); //$NON-NLS-1$
        result.append(maxLength);
        result.append(", maxHeigth: "); //$NON-NLS-1$
        result.append(maxHeigth);
        result.append(')');
        return result.toString();
    }

} //TextAreaFormFieldImpl
