/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.bonitasoft.bpm.model.process.util.migration.InputStreamSupplier;
import org.bonitasoft.bpm.model.process.util.migration.MigrationHelper;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.bpm.model.process.util.migration.MigrationResult;
import org.bonitasoft.bpm.model.util.internal.DuplicatingInputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.xml.sax.SAXException;

public class ProcessResourceImpl
extends XMIResourceImpl {
    public static final String OPTION_MIGRATION_POLICY = "MIGRATION_POLICY";
    private MigrationPolicy migrationPolicy = MigrationPolicy.NEVER_MIGRATE_POLICY;

    public ProcessResourceImpl(URI uri) {
        super(uri);
    }

    public void setMigrationPolicy(MigrationPolicy migrationPolicy) {
        this.migrationPolicy = migrationPolicy;
    }

    protected boolean useUUIDs() {
        return true;
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        Map<Object, Object> overriddenOptions = this.getOverriddenOptions(options);
        super.doSave(outputStream, overriddenOptions);
    }

    private Map<Object, Object> getOverriddenOptions(Map<?, ?> options) {
        HashMap<Object, Object> overriddenOptions = new HashMap<Object, Object>(options);
        if (Boolean.TRUE.equals(options.get("EXTENDED_META_DATA"))) {
            BasicExtendedMetaData extendedMetadataOption = new BasicExtendedMetaData(this.getResourceSet().getPackageRegistry()){
                private Optional<BasicExtendedMetaData.EPackageExtendedMetaData> actorMappingExt;
                {
                    this.actorMappingExt = Optional.empty();
                }

                protected BasicExtendedMetaData.EPackageExtendedMetaData getExtendedMetaData(EPackage ePackage) {
                    String nsURI = ePackage.getNsURI();
                    if (nsURI != null && nsURI.contains("actormapping")) {
                        if (this.actorMappingExt.isEmpty()) {
                            this.actorMappingExt = Optional.of(this.createEPackageExtendedMetaData(ePackage));
                        }
                        return this.actorMappingExt.get();
                    }
                    return super.getExtendedMetaData(ePackage);
                }

                public String getName(EClassifier eClassifier) {
                    String nsURI = eClassifier.getEPackage().getNsURI();
                    if (nsURI != null && nsURI.contains("actormapping") && !"DocumentRoot".equals(eClassifier.getName())) {
                        return eClassifier.getName();
                    }
                    return super.getName(eClassifier);
                }
            };
            overriddenOptions.put("EXTENDED_META_DATA", extendedMetadataOption);
        }
        return overriddenOptions;
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        block23: {
            Map<Object, Object> overriddenOptions;
            Object extendedMetadataOption;
            Object optionValue;
            if (options.containsKey(OPTION_MIGRATION_POLICY) && (optionValue = options.get(OPTION_MIGRATION_POLICY)) instanceof MigrationPolicy) {
                this.setMigrationPolicy((MigrationPolicy)optionValue);
            }
            if ((extendedMetadataOption = (overriddenOptions = this.getOverriddenOptions(options)).get("EXTENDED_META_DATA")) != null) {
                this.getDefaultSaveOptions().put("EXTENDED_META_DATA", extendedMetadataOption);
            }
            if (this.getURIConverter().exists(this.uri, overriddenOptions)) {
                InputStreamSupplier streamSupplier = () -> this.getURIConverter().createInputStream(this.uri, overriddenOptions);
                MigrationResult result = this.checkMigration(streamSupplier, overriddenOptions);
                if (!MigrationResult.SOFT_MIGRATION.equals((Object)result)) {
                    super.doLoad(inputStream, overriddenOptions);
                }
            } else {
                Throwable throwable = null;
                Object var6_9 = null;
                try (DuplicatingInputStream buffered = new DuplicatingInputStream(inputStream);){
                    InputStreamSupplier streamSupplier = buffered::getNonClosingStreamCopy;
                    MigrationResult result = this.checkMigration(streamSupplier, overriddenOptions);
                    if (MigrationResult.SOFT_MIGRATION.equals((Object)result)) break block23;
                    Throwable throwable2 = null;
                    Object var12_16 = null;
                    try (InputStream streamForSuper = buffered.getClosingMasterStreamCopy();){
                        super.doLoad(streamForSuper, overriddenOptions);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected MigrationResult checkMigration(InputStreamSupplier streamSupplier, Map<?, ?> options) throws IOException {
        try {
            MigrationHelper migration = MigrationHelper.getHelper((Resource)this, streamSupplier);
            if (migration.getModelVersionStatus().getSeverity() == 2) {
                return migration.tryAndMigrate(this.migrationPolicy, options, this.getDefaultSaveOptions());
            }
        }
        catch (ParserConfigurationException | MigrationException | SAXException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw new IOException(exception);
        }
        catch (IOException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw exception;
        }
        return MigrationResult.NO_MIGRATION;
    }
}

