/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class DuplicatingInputStream
extends BufferedInputStream {
    private int bufferPosition = 0;

    public DuplicatingInputStream(InputStream in) {
        super(in);
    }

    public DuplicatingInputStream(InputStream in, int size) {
        super(in, size);
    }

    public InputStream getNonClosingStreamCopy() {
        ByteArrayInputStream streamOnBuffer = new ByteArrayInputStream(this.buf);
        return new InputStreamCopy(streamOnBuffer, false);
    }

    public InputStream getClosingMasterStreamCopy() {
        ByteArrayInputStream streamOnBuffer = new ByteArrayInputStream(this.buf);
        return new InputStreamCopy(streamOnBuffer, true);
    }

    private class InputStreamCopy
    extends InputStream {
        private final ByteArrayInputStream streamOnBuffer;
        private boolean isMaster;

        private InputStreamCopy(ByteArrayInputStream streamOnBuffer, boolean isMaster) {
            this.streamOnBuffer = streamOnBuffer;
            this.isMaster = isMaster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            DuplicatingInputStream duplicatingInputStream = DuplicatingInputStream.this;
            synchronized (duplicatingInputStream) {
                int notConsumed = DuplicatingInputStream.this.available();
                if (notConsumed > 0) {
                    return notConsumed;
                }
                return this.streamOnBuffer.available() - this.getBufferPortionNotToRead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            DuplicatingInputStream duplicatingInputStream = DuplicatingInputStream.this;
            synchronized (duplicatingInputStream) {
                int res;
                if (this.streamOnBuffer.available() > this.getBufferPortionNotToRead()) {
                    res = this.streamOnBuffer.read();
                } else {
                    long skip1;
                    if (this.streamOnBuffer.available() > 0 && (skip1 = this.streamOnBuffer.skip(1L)) != 1L) {
                        throw new IOException();
                    }
                    res = DuplicatingInputStream.this.read();
                }
                this.updateBufferPosition();
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            DuplicatingInputStream duplicatingInputStream = DuplicatingInputStream.this;
            synchronized (duplicatingInputStream) {
                int res;
                int readableOnBuffer = this.streamOnBuffer.available() - this.getBufferPortionNotToRead();
                if (len == 0) {
                    res = 0;
                } else if (readableOnBuffer >= len) {
                    res = this.streamOnBuffer.read(b, off, len);
                } else {
                    long skipN;
                    int toReadOnStream;
                    int readOnBuffer;
                    if (readableOnBuffer > 0) {
                        readOnBuffer = this.streamOnBuffer.read(b, off, Math.min(len, readableOnBuffer));
                        toReadOnStream = len - readOnBuffer;
                    } else {
                        readOnBuffer = 0;
                        toReadOnStream = len;
                    }
                    if (this.streamOnBuffer.available() > 0 && (skipN = this.streamOnBuffer.skip(toReadOnStream)) > (long)toReadOnStream) {
                        throw new IOException();
                    }
                    int readFromStream = this.paginatedReadArrayFromStream(b, off, readOnBuffer, toReadOnStream);
                    res = readOnBuffer + readFromStream;
                }
                this.updateBufferPosition();
                return res;
            }
        }

        private int paginatedReadArrayFromStream(byte[] b, int off, int readOnBuffer, int toReadOnStream) throws IOException {
            int readFromStream = 0;
            int stillToRead = toReadOnStream;
            while (stillToRead > 0) {
                int justRead;
                if (stillToRead >= DuplicatingInputStream.this.buf.length) {
                    int pageToRead = DuplicatingInputStream.this.buf.length - 1;
                    justRead = DuplicatingInputStream.this.read(b, readOnBuffer + off, pageToRead);
                } else {
                    justRead = DuplicatingInputStream.this.read(b, readOnBuffer + off, toReadOnStream);
                }
                stillToRead -= justRead;
                if (justRead < 0) {
                    stillToRead = 0;
                    if (readOnBuffer != 0 || readFromStream != 0) continue;
                    readFromStream = -1;
                    continue;
                }
                readFromStream += justRead;
                this.updateBufferPosition();
            }
            return readFromStream;
        }

        @Override
        public void close() throws IOException {
            this.streamOnBuffer.close();
            if (this.isMaster) {
                DuplicatingInputStream.this.close();
            }
        }

        private void updateBufferPosition() {
            if (DuplicatingInputStream.this.pos != 0) {
                DuplicatingInputStream.this.bufferPosition = DuplicatingInputStream.this.pos;
            }
        }

        private int getBufferPortionNotToRead() throws IOException {
            return Optional.ofNullable(DuplicatingInputStream.this.buf).orElseThrow(IOException::new).length - DuplicatingInputStream.this.bufferPosition;
        }
    }
}

