/**
 * Copyright (C) 2009-2022 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2.0 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.bonitasoft.bpm.model.configuration.impl;

import java.util.Collection;

import org.bonitasoft.bpm.model.configuration.ConfigurationPackage;
import org.bonitasoft.bpm.model.configuration.Fragment;
import org.bonitasoft.bpm.model.configuration.FragmentContainer;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Fragment Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.bonitasoft.bpm.model.configuration.impl.FragmentContainerImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.bonitasoft.bpm.model.configuration.impl.FragmentContainerImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.bonitasoft.bpm.model.configuration.impl.FragmentContainerImpl#getFragments <em>Fragments</em>}</li>
 *   <li>{@link org.bonitasoft.bpm.model.configuration.impl.FragmentContainerImpl#getId <em>Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class FragmentContainerImpl extends EObjectImpl implements FragmentContainer {
    /**
     * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getChildren()
     * @generated
     * @ordered
     */
    protected EList<FragmentContainer> children;

    /**
     * The cached value of the '{@link #getFragments() <em>Fragments</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getFragments()
     * @generated
     * @ordered
     */
    protected EList<Fragment> fragments;

    /**
     * The default value of the '{@link #getId() <em>Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getId()
     * @generated
     * @ordered
     */
    protected static final String ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getId()
     * @generated
     * @ordered
     */
    protected String id = ID_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FragmentContainerImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return ConfigurationPackage.Literals.FRAGMENT_CONTAINER;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<FragmentContainer> getChildren() {
        if (children == null) {
            children = new EObjectContainmentWithInverseEList<FragmentContainer>(FragmentContainer.class, this, ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN, ConfigurationPackage.FRAGMENT_CONTAINER__PARENT);
        }
        return children;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public FragmentContainer getParent() {
        if (eContainerFeatureID() != ConfigurationPackage.FRAGMENT_CONTAINER__PARENT) return null;
        return (FragmentContainer)eInternalContainer();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetParent(FragmentContainer newParent, NotificationChain msgs) {
        msgs = eBasicSetContainer((InternalEObject)newParent, ConfigurationPackage.FRAGMENT_CONTAINER__PARENT, msgs);
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setParent(FragmentContainer newParent) {
        if (newParent != eInternalContainer() || (eContainerFeatureID() != ConfigurationPackage.FRAGMENT_CONTAINER__PARENT && newParent != null)) {
            if (EcoreUtil.isAncestor(this, newParent))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString()); //$NON-NLS-1$
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newParent != null)
                msgs = ((InternalEObject)newParent).eInverseAdd(this, ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN, FragmentContainer.class, msgs);
            msgs = basicSetParent(newParent, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.FRAGMENT_CONTAINER__PARENT, newParent, newParent));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<Fragment> getFragments() {
        if (fragments == null) {
            fragments = new EObjectContainmentEList<Fragment>(Fragment.class, this, ConfigurationPackage.FRAGMENT_CONTAINER__FRAGMENTS);
        }
        return fragments;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String getId() {
        return id;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setId(String newId) {
        String oldId = id;
        id = newId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.FRAGMENT_CONTAINER__ID, oldId, id));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildren()).basicAdd(otherEnd, msgs);
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetParent((FragmentContainer)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN:
                return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                return basicSetParent(null, msgs);
            case ConfigurationPackage.FRAGMENT_CONTAINER__FRAGMENTS:
                return ((InternalEList<?>)getFragments()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (eContainerFeatureID()) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                return eInternalContainer().eInverseRemove(this, ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN, FragmentContainer.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN:
                return getChildren();
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                return getParent();
            case ConfigurationPackage.FRAGMENT_CONTAINER__FRAGMENTS:
                return getFragments();
            case ConfigurationPackage.FRAGMENT_CONTAINER__ID:
                return getId();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN:
                getChildren().clear();
                getChildren().addAll((Collection<? extends FragmentContainer>)newValue);
                return;
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                setParent((FragmentContainer)newValue);
                return;
            case ConfigurationPackage.FRAGMENT_CONTAINER__FRAGMENTS:
                getFragments().clear();
                getFragments().addAll((Collection<? extends Fragment>)newValue);
                return;
            case ConfigurationPackage.FRAGMENT_CONTAINER__ID:
                setId((String)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN:
                getChildren().clear();
                return;
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                setParent((FragmentContainer)null);
                return;
            case ConfigurationPackage.FRAGMENT_CONTAINER__FRAGMENTS:
                getFragments().clear();
                return;
            case ConfigurationPackage.FRAGMENT_CONTAINER__ID:
                setId(ID_EDEFAULT);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case ConfigurationPackage.FRAGMENT_CONTAINER__CHILDREN:
                return children != null && !children.isEmpty();
            case ConfigurationPackage.FRAGMENT_CONTAINER__PARENT:
                return getParent() != null;
            case ConfigurationPackage.FRAGMENT_CONTAINER__FRAGMENTS:
                return fragments != null && !fragments.isEmpty();
            case ConfigurationPackage.FRAGMENT_CONTAINER__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (id: "); //$NON-NLS-1$
        result.append(id);
        result.append(')');
        return result.toString();
    }

} //FragmentContainerImpl
