/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GatewayType implements Enumerator
{
    XOR(0, "XOR", "XOR"),
    OR(1, "OR", "OR"),
    COMPLEX(2, "COMPLEX", "COMPLEX"),
    AND(3, "AND", "AND");

    public static final int XOR_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int COMPLEX_VALUE = 2;
    public static final int AND_VALUE = 3;
    private static final GatewayType[] VALUES_ARRAY;
    public static final List<GatewayType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GatewayType[]{XOR, OR, COMPLEX, AND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GatewayType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GatewayType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GatewayType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GatewayType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GatewayType get(int value) {
        switch (value) {
            case 0: {
                return XOR;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return COMPLEX;
            }
            case 3: {
                return AND;
            }
        }
        return null;
    }

    private GatewayType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

