/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process.util.migration;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.bonitasoft.bpm.model.process.util.migration.internal.CustomMigrationFactoryImpl;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.bonitasoft.bpm.model.util.ModelLoader;
import org.bonitasoft.bpm.model.util.internal.ProcContentHandler;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.util.HistoryResourceFactoryImpl;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.MigrationPackage;
import org.eclipse.emf.edapt.spi.migration.util.MigrationValidator;

public class HistoryUtils {
    private static final String PLUGIN_URI_PREFIX = "/org.bonitasoft.bpm.model/";
    private static final String MIGRATION_HISTORY_PATH = "model/process.history";
    public static final ModelLoader.Prerequisite REGISTRATION = ModelLoader.Prerequisite.fromRunnableWhenNotInOSGi(() -> {
        HistoryPackage.eINSTANCE.getNsURI();
        ContentHandler.Registry.INSTANCE.put(10000, (ContentHandler)new ProcContentHandler());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("history", new HistoryResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/edapt/migration/0.3", (Object)new EPackage.Descriptor(){

            public EPackage getEPackage() {
                return null;
            }

            public EFactory getEFactory() {
                return new CustomMigrationFactoryImpl();
            }
        });
    });
    public static final String CURRENT_MODEL_VERSION;
    public static final Predicate<String> IS_KNOWN_VERSION;

    static {
        REGISTRATION.run();
        Resource historyResource = new ResourceSetImpl().getResource(HistoryUtils.getMigrationHistoryURI(), true);
        History history = (History)historyResource.getContents().get(0);
        CURRENT_MODEL_VERSION = history.getLatestRelease().getLabel();
        List knownVersions = history.getReleases().stream().map(Release::getLabel).collect(Collectors.toList());
        IS_KNOWN_VERSION = knownVersions::contains;
        historyResource.unload();
        EValidator.Registry.INSTANCE.put((Object)MigrationPackage.eINSTANCE, (Object)new MigrationValidator(){

            public boolean validateInstance_validContainment(Instance instance, DiagnosticChain diagnostics, Map<Object, Object> context) {
                Optional<EClass> instanceEClass = Optional.of(instance).map(Instance::getEClass).filter(Objects::nonNull);
                if (instanceEClass.filter(ec -> !XMLTypePackage.Literals.ANY_TYPE.isSuperTypeOf(ec)).isPresent()) {
                    return super.validateInstance_validContainment(instance, diagnostics, context);
                }
                return true;
            }
        });
    }

    private HistoryUtils() {
    }

    static URI getMigrationHistoryURI() {
        if (EnvironmentUtil.isOSGi()) {
            return URI.createPlatformPluginURI((String)"/org.bonitasoft.bpm.model/model/process.history", (boolean)false);
        }
        URL url = ProcessPackage.class.getClassLoader().getResource(MIGRATION_HISTORY_PATH);
        return URI.createURI((String)url.toExternalForm());
    }
}

