/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bonitasoft.bpm.model.actormapping.ActorMappingPackage;
import org.bonitasoft.bpm.model.configuration.ConfigurationPackage;
import org.bonitasoft.bpm.model.configuration.util.ConfigurationResourceFactoryImpl;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorConfigurationPackage;
import org.bonitasoft.bpm.model.expression.ExpressionPackage;
import org.bonitasoft.bpm.model.form.FormPackage;
import org.bonitasoft.bpm.model.kpi.KpiPackage;
import org.bonitasoft.bpm.model.parameter.ParameterPackage;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.bonitasoft.bpm.model.process.decision.DecisionPackage;
import org.bonitasoft.bpm.model.process.decision.transitions.TransitionsPackage;
import org.bonitasoft.bpm.model.process.util.ProcessResourceFactoryImpl;
import org.bonitasoft.bpm.model.process.util.migration.HistoryUtils;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.bpm.model.simulation.SimulationPackage;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.bonitasoft.bpm.model.util.internal.ConfigurationContentHandler;
import org.bonitasoft.bpm.model.util.internal.ProcContentHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public final class ModelLoader {
    private static final Prerequisite[] DEFAULT_PREREQUISITE = new Prerequisite[]{HistoryUtils.REGISTRATION, Prerequisite.fromRunnableWhenNotInOSGi(() -> {
        ProcessPackage.eINSTANCE.getNsURI();
        DecisionPackage.eINSTANCE.getNsURI();
        TransitionsPackage.eINSTANCE.getNsURI();
        ActorMappingPackage.eINSTANCE.getNsURI();
        ConfigurationPackage.eINSTANCE.getNsURI();
        ConnectorConfigurationPackage.eINSTANCE.getNsURI();
        ExpressionPackage.eINSTANCE.getNsURI();
        FormPackage.eINSTANCE.getNsURI();
        KpiPackage.eINSTANCE.getNsURI();
        ParameterPackage.eINSTANCE.getNsURI();
        SimulationPackage.eINSTANCE.getNsURI();
        ContentHandler.Registry.INSTANCE.put(10000, (ContentHandler)new ProcContentHandler());
        ContentHandler.Registry.INSTANCE.put(10000, (ContentHandler)new ConfigurationContentHandler());
        Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().put("bonita-process-model", new ProcessResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().put("process-configuration-model", new ConfigurationResourceFactoryImpl());
    })};
    private Map<String, Object> loadOptions = new HashMap<String, Object>();
    private List<Prerequisite> prerequisites = new ArrayList<Prerequisite>();

    public static ModelLoader create() {
        return new ModelLoader();
    }

    private ModelLoader() {
        this.withPrerequisite(DEFAULT_PREREQUISITE);
        this.withPolicy(MigrationPolicy.ALWAYS_MIGRATE_POLICY);
    }

    public Resource loadModel(URL fileUrl) {
        return this.loadModel(URI.createURI((String)fileUrl.toExternalForm()));
    }

    public Resource loadModel(URI modelUri) {
        Object extendedMetadataOption;
        this.prerequisites.forEach(Runnable::run);
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getLoadOptions().putAll(this.loadOptions);
        Resource resource = rset.getResource(modelUri, true);
        if (resource instanceof XMLResource && (extendedMetadataOption = this.loadOptions.get("EXTENDED_META_DATA")) != null) {
            ((XMLResourceImpl)resource).getDefaultSaveOptions().putIfAbsent("EXTENDED_META_DATA", extendedMetadataOption);
        }
        return resource;
    }

    public ModelLoader withPolicy(MigrationPolicy migrationPolicy) {
        this.loadOptions.put("MIGRATION_POLICY", migrationPolicy);
        return this;
    }

    public ModelLoader withPrerequisite(Prerequisite ... prerequisite) {
        this.prerequisites.addAll(Arrays.asList(prerequisite));
        return this;
    }

    public ModelLoader enablePartial() {
        this.loadOptions.putAll(Map.of("EXTENDED_META_DATA", Boolean.TRUE, "RECORD_UNKNOWN_FEATURE", Boolean.TRUE));
        return this;
    }

    public ModelLoader disablePartial() {
        this.loadOptions.remove("EXTENDED_META_DATA");
        this.loadOptions.remove("RECORD_UNKNOWN_FEATURE");
        return this;
    }

    public static abstract class Prerequisite
    implements Runnable {
        private static Map<Runnable, Prerequisite> fromRunnables = new HashMap<Runnable, Prerequisite>();
        private AtomicBoolean hasRun = new AtomicBoolean(false);

        @Override
        public final void run() {
            if (!this.hasRun.getAndSet(true)) {
                this.doRun();
            }
        }

        public abstract void doRun();

        public static Prerequisite fromRunnableWhenNotInOSGi(Runnable runnable) {
            return fromRunnables.computeIfAbsent(runnable, r -> new Prerequisite((Runnable)r){
                private final /* synthetic */ Runnable val$r;
                {
                    this.val$r = runnable;
                }

                @Override
                public void doRun() {
                    if (!EnvironmentUtil.isOSGi()) {
                        this.val$r.run();
                    }
                }
            });
        }
    }
}

