/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.bonitasoft.bpm.model.process.util.migration.InputStreamSupplier;
import org.bonitasoft.bpm.model.process.util.migration.MigrationHelper;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.bpm.model.process.util.migration.MigrationResult;
import org.bonitasoft.bpm.model.process.util.migration.MigrationResultAndStatus;
import org.bonitasoft.bpm.model.util.internal.DuplicatingInputStream;
import org.bonitasoft.bpm.model.util.internal.MigrationExtendedMetaData;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.xml.sax.SAXException;

public class MigratingXMLResource
extends XMLResourceImpl {
    public static final String OPTION_MIGRATION_POLICY = "MIGRATION_POLICY";
    private MigrationPolicy migrationPolicy = MigrationPolicy.NEVER_MIGRATE_POLICY;

    public MigratingXMLResource(URI uri) {
        super(uri);
        this.getDefaultLoadOptions();
        this.getDefaultSaveOptions();
    }

    public void setMigrationPolicy(MigrationPolicy migrationPolicy) {
        this.migrationPolicy = migrationPolicy;
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        block29: {
            Object extendedMetadataOption;
            Object optionValue;
            if (options.containsKey(OPTION_MIGRATION_POLICY) && (optionValue = options.get(OPTION_MIGRATION_POLICY)) instanceof MigrationPolicy) {
                this.setMigrationPolicy((MigrationPolicy)optionValue);
            }
            if ((extendedMetadataOption = options.get("EXTENDED_META_DATA")) != null) {
                this.getDefaultSaveOptions().putIfAbsent("EXTENDED_META_DATA", extendedMetadataOption);
            }
            Optional<MigrationExtendedMetaData> extended = Optional.ofNullable(extendedMetadataOption).filter(MigrationExtendedMetaData.class::isInstance).map(MigrationExtendedMetaData.class::cast);
            if (this.getURIConverter().exists(this.uri, options)) {
                InputStreamSupplier streamSupplier = () -> this.getURIConverter().createInputStream(this.uri, options);
                MigrationResultAndStatus result = this.checkMigration(streamSupplier, options);
                if (!MigrationResult.SOFT_MIGRATION.equals((Object)result.migrationResult())) {
                    if (!result.modelVersionStatus().isOK()) {
                        extended.ifPresent(e -> e.setIsLoadingAnOldMetamodel(true));
                    }
                    try {
                        super.doLoad(inputStream, options);
                    }
                    catch (Throwable throwable) {
                        extended.ifPresent(e -> e.setIsLoadingAnOldMetamodel(false));
                        throw throwable;
                    }
                    extended.ifPresent(e -> e.setIsLoadingAnOldMetamodel(false));
                }
            } else {
                Throwable throwable = null;
                Object var8_9 = null;
                try (DuplicatingInputStream buffered = new DuplicatingInputStream(inputStream);){
                    InputStreamSupplier streamSupplier = buffered::getNonClosingStreamCopy;
                    MigrationResultAndStatus result = this.checkMigration(streamSupplier, options);
                    if (MigrationResult.SOFT_MIGRATION.equals((Object)result.migrationResult())) break block29;
                    if (!result.modelVersionStatus().isOK()) {
                        extended.ifPresent(e -> e.setIsLoadingAnOldMetamodel(true));
                    }
                    try {
                        Throwable throwable2 = null;
                        Object var14_17 = null;
                        try (InputStream streamForSuper = buffered.getClosingMasterStreamCopy();){
                            super.doLoad(streamForSuper, options);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        extended.ifPresent(e -> e.setIsLoadingAnOldMetamodel(false));
                        throw throwable4;
                    }
                    extended.ifPresent(e -> e.setIsLoadingAnOldMetamodel(false));
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected MigrationResultAndStatus checkMigration(InputStreamSupplier streamSupplier, Map<?, ?> options) throws IOException {
        try {
            MigrationHelper migration = MigrationHelper.getHelper((Resource)this, streamSupplier);
            if (migration.getModelVersionStatus().getSeverity() == 2) {
                return migration.tryAndMigrate(this.migrationPolicy, options, this.getDefaultSaveOptions());
            }
            return new MigrationResultAndStatus(MigrationResult.NO_MIGRATION, migration.getModelVersionStatus());
        }
        catch (ParserConfigurationException | MigrationException | SAXException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw new IOException(exception);
        }
        catch (IOException exception) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            throw exception;
        }
    }
}

