/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DocumentType implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    INTERNAL(1, "INTERNAL", "INTERNAL"),
    EXTERNAL(2, "EXTERNAL", "EXTERNAL"),
    CONTRACT(3, "CONTRACT", "CONTRACT");

    public static final int NONE_VALUE = 0;
    public static final int INTERNAL_VALUE = 1;
    public static final int EXTERNAL_VALUE = 2;
    public static final int CONTRACT_VALUE = 3;
    private static final DocumentType[] VALUES_ARRAY;
    public static final List<DocumentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DocumentType[]{NONE, INTERNAL, EXTERNAL, CONTRACT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DocumentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DocumentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DocumentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DocumentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DocumentType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return INTERNAL;
            }
            case 2: {
                return EXTERNAL;
            }
            case 3: {
                return CONTRACT;
            }
        }
        return null;
    }

    private DocumentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

