/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.process.util.migration;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.common.IResourceSetProcessor;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.internal.ClassLoaderFacade;
import org.eclipse.emf.edapt.internal.migration.impl.UpdatingList;
import org.eclipse.emf.edapt.internal.migration.internal.MaterializingBackwardConverter;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.AttributeSlot;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ModelResource;
import org.eclipse.emf.edapt.spi.migration.Slot;

public class LenientResourceMigrator
extends Migrator {
    private static Method migrateMethod;
    private Optional<Migrator> wrappedMigrator = Optional.empty();

    static {
        try {
            migrateMethod = Migrator.class.getDeclaredMethod("migrate", List.class, Release.class, Release.class, IProgressMonitor.class);
            migrateMethod.trySetAccessible();
        }
        catch (NoSuchMethodException | SecurityException e) {
            EcorePlugin.INSTANCE.log((Object)e);
        }
    }

    public LenientResourceMigrator(URI historyURI, IClassLoader classLoader) throws MigrationException {
        super(historyURI, classLoader);
    }

    public LenientResourceMigrator(Migrator original) {
        super(original.getLatestRelease().getHistory(), (IClassLoader)new ClassLoaderFacade(Thread.currentThread().getContextClassLoader()));
        this.wrappedMigrator = Optional.of(original);
    }

    public void migrateAndSave(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor, Map<String, Object> options) throws MigrationException {
        ResourceSet resourceSet = this.migrateAndLoad(modelURIs, sourceRelease, targetRelease, monitor);
        if (resourceSet == null) {
            throw new MigrationException(modelURIs.get(0), "Migration failed. A prior error should be logged.", (Throwable)new NullPointerException());
        }
        try {
            if (resourceSet.getResources().size() > 1) {
                resourceSet.getResources().removeIf(r -> !modelURIs.contains(r.getURI()));
            }
            ResourceUtils.saveResourceSet((ResourceSet)resourceSet, options);
        }
        catch (IOException e) {
            throw new MigrationException((Throwable)e);
        }
    }

    public ResourceSet migrateAndLoad(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        Model model = this.doMigrate(modelURIs, sourceRelease, targetRelease, monitor);
        if (model == null) {
            throw new MigrationException(modelURIs.get(0), "Migration failed. A prior error should be logged.", (Throwable)new NullPointerException());
        }
        CustomMaterializingBackwardConverter converter = new CustomMaterializingBackwardConverter();
        return converter.convert(model);
    }

    public IResourceSetFactory getResourceSetFactory() {
        return this.wrappedMigrator.map(Migrator::getResourceSetFactory).orElseGet(() -> super.getResourceSetFactory());
    }

    public void setResourceSetFactory(IResourceSetFactory resourceSetFactory) {
        this.wrappedMigrator.ifPresentOrElse(m -> m.setResourceSetFactory(resourceSetFactory), () -> super.setResourceSetFactory(resourceSetFactory));
    }

    public void setLevel(ValidationLevel level) {
        this.wrappedMigrator.ifPresentOrElse(m -> m.setLevel(level), () -> super.setLevel(level));
    }

    public IResourceSetProcessor getPostLoadModelProcessor() {
        return this.wrappedMigrator.map(Migrator::getPostLoadModelProcessor).orElseGet(() -> super.getPostLoadModelProcessor());
    }

    public void setPostLoadModelProcessor(IResourceSetProcessor postLoadProcessor) {
        this.wrappedMigrator.ifPresentOrElse(m -> m.setPostLoadModelProcessor(postLoadProcessor), () -> super.setPostLoadModelProcessor(postLoadProcessor));
    }

    private Model doMigrate(List<URI> modelURIs, Release sourceRelease, Release targetRelease, IProgressMonitor monitor) throws MigrationException {
        try {
            Migrator migratorToInvokeOn = this.wrappedMigrator.orElse(this);
            return (Model)migrateMethod.invoke((Object)migratorToInvokeOn, modelURIs, sourceRelease, targetRelease, monitor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            EcorePlugin.INSTANCE.log((Object)e);
            throw new MigrationException((Throwable)e);
        }
    }

    static class CustomMaterializingBackwardConverter
    extends MaterializingBackwardConverter {
        CustomMaterializingBackwardConverter() {
        }

        protected ResourceSet initResources(Model model) {
            ResourceSetImpl resourceSet = new ResourceSetImpl(){

                public Resource createResource(URI uri) {
                    return this.createResource(uri, "");
                }
            };
            ResourceUtils.register((List)model.getMetamodel().getEPackages(), (EPackage.Registry)resourceSet.getPackageRegistry());
            for (ModelResource modelResource : model.getResources()) {
                Resource resource = resourceSet.createResource(modelResource.getUri());
                if (resource instanceof XMLResource) {
                    XMLResource xmlResource = (XMLResource)resource;
                    if (modelResource.getEncoding() != null) {
                        xmlResource.setEncoding(modelResource.getEncoding());
                    }
                }
                for (Instance element : modelResource.getRootInstances()) {
                    resource.getContents().add((Object)this.resolve(element));
                }
            }
            return resourceSet;
        }

        protected EClass resolveEClass(EClass eClass) {
            if (!XMLTypePackage.Literals.ANY_TYPE.isSuperTypeOf(eClass)) {
                return super.resolveEClass(eClass);
            }
            return eClass;
        }

        protected void initProperties(Instance element) {
            Optional<EClass> instanceEClass = Optional.of(element).map(Instance::getEClass).filter(Objects::nonNull);
            if (instanceEClass.filter(ec -> !XMLTypePackage.Literals.ANY_TYPE.isSuperTypeOf(ec)).isPresent()) {
                super.initProperties(element);
            } else {
                AnyType eObject = (AnyType)this.resolve(element);
                for (Slot slot : element.getSlots()) {
                    EStructuralFeature sourceFeature = slot.getEFeature();
                    EStructuralFeature targetFeature = this.resolveFeature(sourceFeature);
                    if (this.ignore(sourceFeature) || !(slot instanceof AttributeSlot) || !FeatureMap.Entry.class.isAssignableFrom(sourceFeature.getEType().getInstanceClass())) continue;
                    FeatureMap objectFeatureMap = (FeatureMap)eObject.eGet(targetFeature);
                    UpdatingList valuesMap = (UpdatingList)element.get(sourceFeature);
                    for (Object v : valuesMap) {
                        FeatureMap.Entry e = (FeatureMap.Entry)v;
                        objectFeatureMap.add(e.getEStructuralFeature(), e.getValue());
                    }
                }
            }
        }
    }
}

