/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.form;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FileWidgetInputType implements Enumerator
{
    DOCUMENT(0, "Document", "Document"),
    URL(1, "URL", "URL"),
    RESOURCE(2, "Resource", "Resource");

    public static final int DOCUMENT_VALUE = 0;
    public static final int URL_VALUE = 1;
    public static final int RESOURCE_VALUE = 2;
    private static final FileWidgetInputType[] VALUES_ARRAY;
    public static final List<FileWidgetInputType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FileWidgetInputType[]{DOCUMENT, URL, RESOURCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FileWidgetInputType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileWidgetInputType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileWidgetInputType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileWidgetInputType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileWidgetInputType get(int value) {
        switch (value) {
            case 0: {
                return DOCUMENT;
            }
            case 1: {
                return URL;
            }
            case 2: {
                return RESOURCE;
            }
        }
        return null;
    }

    private FileWidgetInputType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

