/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bpm.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.DataAware;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.SequenceFlow;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelSearch
implements IModelSearch {
    private Supplier<List<Pool>> processContextProvider;

    public ModelSearch(Supplier<List<Pool>> processContextProvider) {
        this.processContextProvider = processContextProvider;
    }

    @Override
    public <T> List<T> getAllItemsOfType(EObject parent, Class<T> type) {
        ArrayList res = new ArrayList();
        ModelSearch.addAllElementOfContainer(parent, res, type);
        return res;
    }

    @Override
    public boolean isInEvenementialSubProcessPool(EObject element) {
        EObject current = element;
        while (current != null && !(current instanceof SubProcessEvent)) {
            current = current.eContainer();
        }
        return current instanceof SubProcessEvent;
    }

    @Override
    public <T> T getDirectParentOfType(EObject element, Class<T> type) {
        EObject result = element;
        while (result != null && !type.isAssignableFrom(result.getClass())) {
            result = result.eContainer();
        }
        return (T)(result != null && type.isAssignableFrom(result.getClass()) ? result : null);
    }

    private static <T> void addAllElementOfContainer(EObject parent, List<T> res, Class<T> type) {
        if (parent != null) {
            if (type.isAssignableFrom(parent.getClass())) {
                res.add(parent);
            }
            for (EObject child : parent.eContents()) {
                ModelSearch.addAllElementOfContainer(child, res, type);
            }
        }
    }

    @Override
    public Optional<Pool> findProcess(String name, String version) {
        List<Pool> allProcesses = this.processContextProvider.get();
        if (version == null || version.trim().isEmpty()) {
            return allProcesses.stream().filter(process -> Objects.equals(process.getName(), name)).sorted((p1, p2) -> p1.getVersion().compareTo(p2.getVersion())).findFirst();
        }
        return allProcesses.stream().filter(process -> Objects.equals(process.getName(), name)).filter(process -> Objects.equals(process.getVersion(), version)).findFirst();
    }

    @Override
    public List<Data> getAccessibleData(EObject element) {
        ArrayList<Data> data = new ArrayList<Data>();
        EObject currentElement = element;
        boolean processFound = false;
        while (!processFound && currentElement != null) {
            if (currentElement instanceof SequenceFlow && ((SequenceFlow)currentElement).getSource() instanceof DataAware) {
                data.addAll((Collection<Data>)((DataAware)((Object)((SequenceFlow)currentElement).getSource())).getData());
            }
            if (currentElement instanceof DataAware) {
                data.addAll((Collection<Data>)((DataAware)currentElement).getData());
            }
            processFound = currentElement instanceof AbstractProcess && !(currentElement instanceof SubProcessEvent);
            currentElement = currentElement.eContainer();
        }
        return data;
    }

    @Override
    public String getEObjectID(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource eResource = eObject.eResource();
        if (eResource != null) {
            return eResource.getURIFragment(eObject);
        }
        return null;
    }
}

