/**
 * Copyright (C) 2023 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2.0 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.omg.spec.bpmn.di.impl;

import javax.xml.namespace.QName;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.omg.spec.bpmn.di.BPMNEdge;
import org.omg.spec.bpmn.di.BPMNLabel;
import org.omg.spec.bpmn.di.DiPackage;
import org.omg.spec.bpmn.di.MessageVisibleKind;

import org.omg.spec.dd.di.impl.LabeledEdgeImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BPMN Edge</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.omg.spec.bpmn.di.impl.BPMNEdgeImpl#getBPMNLabel <em>BPMN Label</em>}</li>
 *   <li>{@link org.omg.spec.bpmn.di.impl.BPMNEdgeImpl#getBpmnElement <em>Bpmn Element</em>}</li>
 *   <li>{@link org.omg.spec.bpmn.di.impl.BPMNEdgeImpl#getMessageVisibleKind <em>Message Visible Kind</em>}</li>
 *   <li>{@link org.omg.spec.bpmn.di.impl.BPMNEdgeImpl#getSourceElement <em>Source Element</em>}</li>
 *   <li>{@link org.omg.spec.bpmn.di.impl.BPMNEdgeImpl#getTargetElement <em>Target Element</em>}</li>
 * </ul>
 *
 * @generated
 */
public class BPMNEdgeImpl extends LabeledEdgeImpl implements BPMNEdge {

    /**
     * The cached value of the '{@link #getBPMNLabel() <em>BPMN Label</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getBPMNLabel()
     * @generated
     * @ordered
     */
    protected BPMNLabel bPMNLabel;

    /**
     * The default value of the '{@link #getBpmnElement() <em>Bpmn Element</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getBpmnElement()
     * @generated
     * @ordered
     */
    protected static final QName BPMN_ELEMENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getBpmnElement() <em>Bpmn Element</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getBpmnElement()
     * @generated
     * @ordered
     */
    protected QName bpmnElement = BPMN_ELEMENT_EDEFAULT;

    /**
     * The default value of the '{@link #getMessageVisibleKind() <em>Message Visible Kind</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMessageVisibleKind()
     * @generated
     * @ordered
     */
    protected static final MessageVisibleKind MESSAGE_VISIBLE_KIND_EDEFAULT = MessageVisibleKind.INITIATING;

    /**
     * The cached value of the '{@link #getMessageVisibleKind() <em>Message Visible Kind</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMessageVisibleKind()
     * @generated
     * @ordered
     */
    protected MessageVisibleKind messageVisibleKind = MESSAGE_VISIBLE_KIND_EDEFAULT;

    /**
     * This is true if the Message Visible Kind attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean messageVisibleKindESet;

    /**
     * The default value of the '{@link #getSourceElement() <em>Source Element</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSourceElement()
     * @generated
     * @ordered
     */
    protected static final QName SOURCE_ELEMENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSourceElement() <em>Source Element</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSourceElement()
     * @generated
     * @ordered
     */
    protected QName sourceElement = SOURCE_ELEMENT_EDEFAULT;

    /**
     * The default value of the '{@link #getTargetElement() <em>Target Element</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTargetElement()
     * @generated
     * @ordered
     */
    protected static final QName TARGET_ELEMENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTargetElement() <em>Target Element</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTargetElement()
     * @generated
     * @ordered
     */
    protected QName targetElement = TARGET_ELEMENT_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BPMNEdgeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return DiPackage.Literals.BPMN_EDGE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BPMNLabel getBPMNLabel() {
        return bPMNLabel;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetBPMNLabel(BPMNLabel newBPMNLabel, NotificationChain msgs) {
        BPMNLabel oldBPMNLabel = bPMNLabel;
        bPMNLabel = newBPMNLabel;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
                    DiPackage.BPMN_EDGE__BPMN_LABEL, oldBPMNLabel, newBPMNLabel);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setBPMNLabel(BPMNLabel newBPMNLabel) {
        if (newBPMNLabel != bPMNLabel) {
            NotificationChain msgs = null;
            if (bPMNLabel != null)
                msgs = ((InternalEObject) bPMNLabel).eInverseRemove(this,
                        EOPPOSITE_FEATURE_BASE - DiPackage.BPMN_EDGE__BPMN_LABEL, null, msgs);
            if (newBPMNLabel != null)
                msgs = ((InternalEObject) newBPMNLabel).eInverseAdd(this,
                        EOPPOSITE_FEATURE_BASE - DiPackage.BPMN_EDGE__BPMN_LABEL, null, msgs);
            msgs = basicSetBPMNLabel(newBPMNLabel, msgs);
            if (msgs != null)
                msgs.dispatch();
        } else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DiPackage.BPMN_EDGE__BPMN_LABEL, newBPMNLabel,
                    newBPMNLabel));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public QName getBpmnElement() {
        return bpmnElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setBpmnElement(QName newBpmnElement) {
        QName oldBpmnElement = bpmnElement;
        bpmnElement = newBpmnElement;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DiPackage.BPMN_EDGE__BPMN_ELEMENT, oldBpmnElement,
                    bpmnElement));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public MessageVisibleKind getMessageVisibleKind() {
        return messageVisibleKind;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMessageVisibleKind(MessageVisibleKind newMessageVisibleKind) {
        MessageVisibleKind oldMessageVisibleKind = messageVisibleKind;
        messageVisibleKind = newMessageVisibleKind == null ? MESSAGE_VISIBLE_KIND_EDEFAULT : newMessageVisibleKind;
        boolean oldMessageVisibleKindESet = messageVisibleKindESet;
        messageVisibleKindESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DiPackage.BPMN_EDGE__MESSAGE_VISIBLE_KIND,
                    oldMessageVisibleKind, messageVisibleKind, !oldMessageVisibleKindESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void unsetMessageVisibleKind() {
        MessageVisibleKind oldMessageVisibleKind = messageVisibleKind;
        boolean oldMessageVisibleKindESet = messageVisibleKindESet;
        messageVisibleKind = MESSAGE_VISIBLE_KIND_EDEFAULT;
        messageVisibleKindESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, DiPackage.BPMN_EDGE__MESSAGE_VISIBLE_KIND,
                    oldMessageVisibleKind, MESSAGE_VISIBLE_KIND_EDEFAULT, oldMessageVisibleKindESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isSetMessageVisibleKind() {
        return messageVisibleKindESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public QName getSourceElement() {
        return sourceElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setSourceElement(QName newSourceElement) {
        QName oldSourceElement = sourceElement;
        sourceElement = newSourceElement;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DiPackage.BPMN_EDGE__SOURCE_ELEMENT, oldSourceElement,
                    sourceElement));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public QName getTargetElement() {
        return targetElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setTargetElement(QName newTargetElement) {
        QName oldTargetElement = targetElement;
        targetElement = newTargetElement;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DiPackage.BPMN_EDGE__TARGET_ELEMENT, oldTargetElement,
                    targetElement));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case DiPackage.BPMN_EDGE__BPMN_LABEL:
                return basicSetBPMNLabel(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case DiPackage.BPMN_EDGE__BPMN_LABEL:
                return getBPMNLabel();
            case DiPackage.BPMN_EDGE__BPMN_ELEMENT:
                return getBpmnElement();
            case DiPackage.BPMN_EDGE__MESSAGE_VISIBLE_KIND:
                return getMessageVisibleKind();
            case DiPackage.BPMN_EDGE__SOURCE_ELEMENT:
                return getSourceElement();
            case DiPackage.BPMN_EDGE__TARGET_ELEMENT:
                return getTargetElement();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case DiPackage.BPMN_EDGE__BPMN_LABEL:
                setBPMNLabel((BPMNLabel) newValue);
                return;
            case DiPackage.BPMN_EDGE__BPMN_ELEMENT:
                setBpmnElement((QName) newValue);
                return;
            case DiPackage.BPMN_EDGE__MESSAGE_VISIBLE_KIND:
                setMessageVisibleKind((MessageVisibleKind) newValue);
                return;
            case DiPackage.BPMN_EDGE__SOURCE_ELEMENT:
                setSourceElement((QName) newValue);
                return;
            case DiPackage.BPMN_EDGE__TARGET_ELEMENT:
                setTargetElement((QName) newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case DiPackage.BPMN_EDGE__BPMN_LABEL:
                setBPMNLabel((BPMNLabel) null);
                return;
            case DiPackage.BPMN_EDGE__BPMN_ELEMENT:
                setBpmnElement(BPMN_ELEMENT_EDEFAULT);
                return;
            case DiPackage.BPMN_EDGE__MESSAGE_VISIBLE_KIND:
                unsetMessageVisibleKind();
                return;
            case DiPackage.BPMN_EDGE__SOURCE_ELEMENT:
                setSourceElement(SOURCE_ELEMENT_EDEFAULT);
                return;
            case DiPackage.BPMN_EDGE__TARGET_ELEMENT:
                setTargetElement(TARGET_ELEMENT_EDEFAULT);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case DiPackage.BPMN_EDGE__BPMN_LABEL:
                return bPMNLabel != null;
            case DiPackage.BPMN_EDGE__BPMN_ELEMENT:
                return BPMN_ELEMENT_EDEFAULT == null ? bpmnElement != null : !BPMN_ELEMENT_EDEFAULT.equals(bpmnElement);
            case DiPackage.BPMN_EDGE__MESSAGE_VISIBLE_KIND:
                return isSetMessageVisibleKind();
            case DiPackage.BPMN_EDGE__SOURCE_ELEMENT:
                return SOURCE_ELEMENT_EDEFAULT == null ? sourceElement != null
                        : !SOURCE_ELEMENT_EDEFAULT.equals(sourceElement);
            case DiPackage.BPMN_EDGE__TARGET_ELEMENT:
                return TARGET_ELEMENT_EDEFAULT == null ? targetElement != null
                        : !TARGET_ELEMENT_EDEFAULT.equals(targetElement);
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (bpmnElement: "); //$NON-NLS-1$
        result.append(bpmnElement);
        result.append(", messageVisibleKind: "); //$NON-NLS-1$
        if (messageVisibleKindESet)
            result.append(messageVisibleKind);
        else
            result.append("<unset>"); //$NON-NLS-1$
        result.append(", sourceElement: "); //$NON-NLS-1$
        result.append(sourceElement);
        result.append(", targetElement: "); //$NON-NLS-1$
        result.append(targetElement);
        result.append(')');
        return result.toString();
    }

} //BPMNEdgeImpl
