/**
 * Copyright (C) 2023 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2.0 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.omg.spec.bpmn.di;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.omg.spec.bpmn.di.DiPackage
 * @generated
 */
public interface DiFactory extends EFactory {

    /**
     * The singleton instance of the factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    DiFactory eINSTANCE = org.omg.spec.bpmn.di.impl.DiFactoryImpl.init();

    /**
     * Returns a new object of class '<em>BPMN Diagram</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>BPMN Diagram</em>'.
     * @generated
     */
    BPMNDiagram createBPMNDiagram();

    /**
     * Returns a new object of class '<em>BPMN Edge</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>BPMN Edge</em>'.
     * @generated
     */
    BPMNEdge createBPMNEdge();

    /**
     * Returns a new object of class '<em>BPMN Label</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>BPMN Label</em>'.
     * @generated
     */
    BPMNLabel createBPMNLabel();

    /**
     * Returns a new object of class '<em>BPMN Label Style</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>BPMN Label Style</em>'.
     * @generated
     */
    BPMNLabelStyle createBPMNLabelStyle();

    /**
     * Returns a new object of class '<em>BPMN Plane</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>BPMN Plane</em>'.
     * @generated
     */
    BPMNPlane createBPMNPlane();

    /**
     * Returns a new object of class '<em>BPMN Shape</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>BPMN Shape</em>'.
     * @generated
     */
    BPMNShape createBPMNShape();

    /**
     * Returns a new object of class '<em>Document Root</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Document Root</em>'.
     * @generated
     */
    DocumentRoot createDocumentRoot();

    /**
     * Returns the package supported by this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the package supported by this factory.
     * @generated
     */
    DiPackage getDiPackage();

} //DiFactory
