/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.ask;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.util.ArrayList;
import lombok.Generated;
import org.bonitasoft.connectors.ai.AbstractAiChat;
import org.bonitasoft.connectors.ai.AiChat;
import org.bonitasoft.connectors.ai.AiConfiguration;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.ask.AskChat;
import org.bonitasoft.connectors.utils.AiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AskAiChat<T extends ChatLanguageModel>
extends AbstractAiChat<T>
implements AiChat<T>,
AskChat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AskAiChat.class);
    protected final AiConfiguration configuration;

    protected AskAiChat(AiConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public AiConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String ask(String systemPrompt, String userPrompt, String jsonSchema, UserDocument document) {
        ArrayList<Object> messages = new ArrayList<Object>();
        SystemMessage systemMessage = SystemMessage.from((String)systemPrompt);
        messages.add(systemMessage);
        StringBuilder userPromptText = new StringBuilder(userPrompt);
        if (jsonSchema != null && !jsonSchema.isEmpty()) {
            userPromptText.append("**Instructions:**\n1. If the information is not explicitly stated, use context and reasoning to infer the answer.\n2. If a requested piece of information is not present in the text, clearly indicate that it is \"Absent\" without any additional explanation or commentary.\n5. Follow the format instructions precisely.\n6. Format the answer information clearly and structured in JSON format and formatted according to this JSON schema:\n");
            userPromptText.append("\n   ").append(jsonSchema);
            userPromptText.append("7. Do not include markdown in the output.\n8. Do not include the JSON schema in the JSON output.\n9. Answer must only contain the JSON output.\n10.Do not include ```json ``` in the output.\n");
        }
        UserMessage userMessage = UserMessage.from((String)userPromptText.toString());
        messages.add(userMessage);
        if (document != null) {
            ChatMessage docMessage = this.newDocMessage(document);
            messages.add(docMessage);
        }
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        ChatResponse chatResponse = this.getChatModel().chat(chatRequest);
        if (jsonSchema != null && !jsonSchema.isEmpty()) {
            return AiResponse.ensureJson(chatResponse.aiMessage().text());
        }
        return chatResponse.aiMessage().text();
    }
}

