/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.extract;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.connectors.ai.AbstractAiChat;
import org.bonitasoft.connectors.ai.AiChat;
import org.bonitasoft.connectors.ai.AiConfiguration;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.extract.ExtractChat;
import org.bonitasoft.connectors.utils.AiResponse;
import org.bonitasoft.connectors.utils.IOs;

public abstract class ExtractAiChat<T extends ChatLanguageModel>
extends AbstractAiChat<T>
implements AiChat<T>,
ExtractChat {
    protected final String systemPrompt;
    protected final String userPrompt;
    protected final String userPromptWthJsonSchema;
    protected final AiConfiguration configuration;

    protected ExtractAiChat(AiConfiguration configuration) {
        this.configuration = configuration;
        this.systemPrompt = IOs.readAsString("/prompt/extract/system.txt");
        this.userPrompt = IOs.readAsString("/prompt/extract/user.txt");
        this.userPromptWthJsonSchema = IOs.readAsString("/prompt/extract/user_with_json_schema.txt");
    }

    @Override
    public AiConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String extract(UserDocument document, List<String> fields) {
        String fieldsToExtractForPrompt = String.join((CharSequence)"\n   - ", fields);
        Prompt prompt = PromptTemplate.from((String)this.userPrompt).apply(Map.of("fieldsToExtract", fieldsToExtractForPrompt));
        return this.doExtract(document, prompt.text());
    }

    @Override
    public String extract(UserDocument document, String jsonSchema) {
        Prompt prompt = PromptTemplate.from((String)this.userPromptWthJsonSchema).apply(Map.of("jsonSchema", jsonSchema));
        return this.doExtract(document, prompt.text());
    }

    String doExtract(UserDocument document, String userText) {
        ArrayList<Object> messages = new ArrayList<Object>();
        SystemMessage systemMessage = SystemMessage.from((String)this.systemPrompt);
        messages.add(systemMessage);
        UserMessage userMessage = UserMessage.from((String)userText);
        messages.add(userMessage);
        ChatMessage docMessage = this.newDocMessage(document);
        messages.add(docMessage);
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        ChatResponse chatResponse = this.getChatModel().chat(chatRequest);
        return AiResponse.ensureJson(chatResponse.aiMessage().text());
    }
}

