/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.langchain4j;

import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.bonitasoft.connectors.ai.AiConnectorException;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.connector.EngineExecutionContext;

public class BonitaDocumentSource
implements DocumentSource {
    private final Metadata metadata = new Metadata();
    private byte[] data = new byte[0];

    public BonitaDocumentSource(ProcessAPI processAPI, EngineExecutionContext executionContext, String docRef) {
        ValidationUtils.ensureNotNull((Object)executionContext, (String)"executionContext");
        ValidationUtils.ensureNotNull((Object)processAPI, (String)"processAPI");
        ValidationUtils.ensureNotNull((Object)docRef, (String)Metadatas.DOC_REF.name());
        this.metadata.put(Metadatas.DOC_REF.name(), docRef);
        if (!docRef.isEmpty()) {
            try {
                long processInstanceId = executionContext.getProcessInstanceId();
                Document document = processAPI.getLastDocument(processInstanceId, docRef);
                this.metadata.put(Metadatas.FILE_NAME.name(), document.getContentFileName());
                this.metadata.put(Metadatas.AUTHOR.name(), document.getAuthor());
                this.metadata.put(Metadatas.MIME_TYPE.name(), document.getContentMimeType());
                this.metadata.put(Metadatas.DESCRIPTION.name(), document.getDescription());
                this.metadata.put(Metadatas.CREATION_DATE.name(), document.getCreationDate().toString());
                this.data = processAPI.getDocumentContent(document.getContentStorageId());
            }
            catch (DocumentNotFoundException e) {
                throw new AiConnectorException("Document not found for ref: " + docRef, e);
            }
        }
    }

    public InputStream inputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public static enum Metadatas {
        DOC_REF,
        FILE_NAME,
        AUTHOR,
        MIME_TYPE,
        DESCRIPTION,
        CREATION_DATE;

    }
}

