/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.mistral;

import dev.langchain4j.model.mistralai.MistralAiChatModel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.bonitasoft.connectors.ai.AiChat;
import org.bonitasoft.connectors.ai.AiConfiguration;

public interface MistralAiChat
extends AiChat<MistralAiChatModel> {
    public static final String PIXTRAL_12_B_2409 = "pixtral-12b-2409";

    default public MistralAiChatModel getChatModel() {
        AiConfiguration configuration = this.getConfiguration();
        MistralAiChatModel.MistralAiChatModelBuilder chatModelBuilder = MistralAiChatModel.builder().logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true));
        chatModelBuilder.apiKey(configuration.getApiKey());
        configuration.getBaseUrl().ifPresent(arg_0 -> ((MistralAiChatModel.MistralAiChatModelBuilder)chatModelBuilder).baseUrl(arg_0));
        chatModelBuilder.modelName(configuration.getChatModelName().orElse(PIXTRAL_12_B_2409));
        configuration.getModelTemperature().ifPresent(arg_0 -> ((MistralAiChatModel.MistralAiChatModelBuilder)chatModelBuilder).temperature(arg_0));
        configuration.getRequestTimeout().ifPresent(timeout -> chatModelBuilder.timeout(Duration.of(timeout.intValue(), ChronoUnit.MILLIS)));
        return chatModelBuilder.build();
    }
}

