/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ToolSpecifications {
    private ToolSpecifications() {
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Class<?> classWithTools) {
        List<ToolSpecification> toolSpecifications = Arrays.stream(classWithTools.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(ToolSpecifications::toolSpecificationFrom).collect(Collectors.toList());
        ToolSpecifications.validateSpecifications(toolSpecifications);
        return toolSpecifications;
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Object objectWithTools) {
        return ToolSpecifications.toolSpecificationsFrom(objectWithTools.getClass());
    }

    public static void validateSpecifications(List<ToolSpecification> toolSpecifications) throws IllegalArgumentException {
        HashSet<String> names = new HashSet<String>();
        for (ToolSpecification toolSpecification : toolSpecifications) {
            if (names.add(toolSpecification.name())) continue;
            throw new IllegalArgumentException(String.format("Tool names must be unique. The tool '%s' appears several times", toolSpecification.name()));
        }
    }

    public static ToolSpecification toolSpecificationFrom(Method method) {
        Tool annotation = method.getAnnotation(Tool.class);
        String name = Utils.isNullOrBlank(annotation.name()) ? method.getName() : annotation.name();
        String description = String.join((CharSequence)"\n", annotation.value());
        if (description.isEmpty()) {
            description = null;
        }
        JsonObjectSchema parameters = ToolSpecifications.parametersFrom(method.getParameters());
        return ToolSpecification.builder().name(name).description(description).parameters(parameters).build();
    }

    private static JsonObjectSchema parametersFrom(Parameter[] parameters) {
        LinkedHashMap<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        ArrayList<String> required = new ArrayList<String>();
        LinkedHashMap visited = new LinkedHashMap();
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(ToolMemoryId.class)) continue;
            boolean isRequired = Optional.ofNullable(parameter.getAnnotation(P.class)).map(P::required).orElse(true);
            properties.put(parameter.getName(), ToolSpecifications.jsonSchemaElementFrom(parameter, visited));
            if (!isRequired) continue;
            required.add(parameter.getName());
        }
        LinkedHashMap<String, JsonSchemaElement> definitions = new LinkedHashMap<String, JsonSchemaElement>();
        visited.forEach((clazz, visitedClassMetadata) -> {
            if (visitedClassMetadata.recursionDetected) {
                definitions.put(visitedClassMetadata.reference, visitedClassMetadata.jsonSchemaElement);
            }
        });
        if (properties.isEmpty()) {
            return null;
        }
        return JsonObjectSchema.builder().addProperties(properties).required(required).definitions(definitions.isEmpty() ? null : definitions).build();
    }

    private static JsonSchemaElement jsonSchemaElementFrom(Parameter parameter, Map<Class<?>, JsonSchemaElementHelper.VisitedClassMetadata> visited) {
        P annotation = parameter.getAnnotation(P.class);
        String description = annotation == null ? null : annotation.value();
        return JsonSchemaElementHelper.jsonSchemaElementFrom(parameter.getType(), parameter.getParameterizedType(), description, true, visited);
    }
}

