/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ListenersUtil;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public interface StreamingChatLanguageModel {
    default public void chat(ChatRequest chatRequest, final StreamingChatResponseHandler handler2) {
        final ChatRequest finalChatRequest = ChatRequest.builder().messages(chatRequest.messages()).parameters(this.defaultRequestParameters().overrideWith(chatRequest.parameters())).build();
        final List<ChatModelListener> listeners = this.listeners();
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        StreamingChatResponseHandler observingHandler = new StreamingChatResponseHandler(){

            @Override
            public void onPartialResponse(String partialResponse) {
                handler2.onPartialResponse(partialResponse);
            }

            @Override
            public void onCompleteResponse(ChatResponse completeResponse) {
                ListenersUtil.onResponse(completeResponse, finalChatRequest, StreamingChatLanguageModel.this.provider(), attributes, listeners);
                handler2.onCompleteResponse(completeResponse);
            }

            @Override
            public void onError(Throwable error) {
                ListenersUtil.onError(error, finalChatRequest, StreamingChatLanguageModel.this.provider(), attributes, listeners);
                handler2.onError(error);
            }
        };
        ListenersUtil.onRequest(finalChatRequest, this.provider(), attributes, listeners);
        this.doChat(finalChatRequest, observingHandler);
    }

    default public ChatRequestParameters defaultRequestParameters() {
        return ChatRequestParameters.builder().build();
    }

    default public List<ChatModelListener> listeners() {
        return Collections.emptyList();
    }

    default public ModelProvider provider() {
        return ModelProvider.OTHER;
    }

    default public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler2) {
        throw new RuntimeException("Not implemented");
    }

    default public void chat(String userMessage, StreamingChatResponseHandler handler2) {
        ChatRequest chatRequest = ChatRequest.builder().messages(UserMessage.from(userMessage)).build();
        this.chat(chatRequest, handler2);
    }

    default public void chat(List<ChatMessage> messages, StreamingChatResponseHandler handler2) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        this.chat(chatRequest, handler2);
    }

    default public Set<Capability> supportedCapabilities() {
        return Set.of();
    }
}

