/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.chain;

import dev.langchain4j.chain.Chain;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.DefaultRetrievalAugmentor;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Metadata;
import java.util.List;

public class ConversationalRetrievalChain
implements Chain<String, String> {
    private final ChatLanguageModel chatLanguageModel;
    private final ChatMemory chatMemory;
    private final RetrievalAugmentor retrievalAugmentor;

    public ConversationalRetrievalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory, ContentRetriever contentRetriever) {
        this(chatLanguageModel, chatMemory, (RetrievalAugmentor)DefaultRetrievalAugmentor.builder().contentRetriever(contentRetriever).build());
    }

    public ConversationalRetrievalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory, RetrievalAugmentor retrievalAugmentor) {
        this.chatLanguageModel = (ChatLanguageModel)ValidationUtils.ensureNotNull((Object)chatLanguageModel, (String)"chatLanguageModel");
        this.chatMemory = (ChatMemory)Utils.getOrDefault((Object)chatMemory, () -> MessageWindowChatMemory.withMaxMessages(10));
        this.retrievalAugmentor = (RetrievalAugmentor)ValidationUtils.ensureNotNull((Object)retrievalAugmentor, (String)"retrievalAugmentor");
    }

    @Override
    public String execute(String query) {
        UserMessage userMessage = UserMessage.from((String)query);
        userMessage = this.augment(userMessage);
        this.chatMemory.add((ChatMessage)userMessage);
        AiMessage aiMessage = this.chatLanguageModel.chat(this.chatMemory.messages()).aiMessage();
        this.chatMemory.add((ChatMessage)aiMessage);
        return aiMessage.text();
    }

    private UserMessage augment(UserMessage userMessage) {
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)this.chatMemory.id(), (List)this.chatMemory.messages());
        AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)userMessage, metadata);
        AugmentationResult augmentationResult = this.retrievalAugmentor.augment(augmentationRequest);
        return (UserMessage)augmentationResult.chatMessage();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatLanguageModel chatLanguageModel;
        private ChatMemory chatMemory;
        private RetrievalAugmentor retrievalAugmentor;

        public Builder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public Builder chatMemory(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
            return this;
        }

        public Builder contentRetriever(ContentRetriever contentRetriever) {
            if (contentRetriever != null) {
                this.retrievalAugmentor = DefaultRetrievalAugmentor.builder().contentRetriever(contentRetriever).build();
            }
            return this;
        }

        public Builder retrievalAugmentor(RetrievalAugmentor retrievalAugmentor) {
            this.retrievalAugmentor = retrievalAugmentor;
            return this;
        }

        public ConversationalRetrievalChain build() {
            return new ConversationalRetrievalChain(this.chatLanguageModel, this.chatMemory, this.retrievalAugmentor);
        }
    }
}

