/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.ParsingUtils;
import java.util.Optional;

class FloatOutputParser
implements OutputParser<Float> {
    FloatOutputParser() {
    }

    @Override
    public Float parse(String text) {
        return ParsingUtils.parseAsStringOrJson(text, Float::parseFloat, Float.class);
    }

    @Override
    public Optional<JsonSchema> jsonSchema() {
        JsonSchema jsonSchema = JsonSchema.builder().name("number").rootElement((JsonSchemaElement)JsonObjectSchema.builder().addNumberProperty("value").required(new String[]{"value"}).build()).build();
        return Optional.of(jsonSchema);
    }

    @Override
    public String formatInstructions() {
        return "floating point number";
    }
}

