/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.TypeUtils;
import dev.langchain4j.service.output.DefaultOutputParserFactory;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.PojoOutputParser;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Optional;

@Experimental
public class JsonSchemas {
    public static Optional<JsonSchema> jsonSchemaFrom(Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterType(returnType);
        }
        if (returnType == Void.TYPE) {
            throw IllegalConfigurationException.illegalConfiguration("Return type of method '%s' cannot be void");
        }
        if (!JsonSchemas.isPojo(returnType)) {
            return Optional.empty();
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        JsonSchema jsonSchema = JsonSchema.builder().name(rawClass.getSimpleName()).rootElement(JsonSchemaElementHelper.jsonObjectOrReferenceSchemaFrom(rawClass, null, (boolean)false, new LinkedHashMap(), (boolean)true)).build();
        return Optional.of(jsonSchema);
    }

    private static boolean isPojo(Type returnType) {
        if (returnType == String.class || returnType == AiMessage.class || returnType == TokenStream.class || returnType == Response.class) {
            return false;
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        Class<?> typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType);
        OutputParser<?> outputParser = new DefaultOutputParserFactory().get(rawClass, typeArgumentClass);
        return outputParser instanceof PojoOutputParser;
    }
}

