/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.openai;

import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.bonitasoft.connectors.ai.AiChat;
import org.bonitasoft.connectors.ai.AiConfiguration;

public interface OpenAiChat
extends AiChat<OpenAiChatModel> {
    default public OpenAiChatModel getChatModel() {
        AiConfiguration configuration = this.getConfiguration();
        OpenAiChatModel.OpenAiChatModelBuilder chatModelBuilder = OpenAiChatModel.builder().logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true));
        chatModelBuilder.apiKey(configuration.getApiKey());
        configuration.getBaseUrl().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)chatModelBuilder).baseUrl(arg_0));
        chatModelBuilder.modelName(configuration.getChatModelName().orElse(OpenAiChatModelName.GPT_4_O.toString()));
        configuration.getModelTemperature().ifPresent(arg_0 -> ((OpenAiChatModel.OpenAiChatModelBuilder)chatModelBuilder).temperature(arg_0));
        configuration.getRequestTimeout().ifPresent(timeout -> chatModelBuilder.timeout(Duration.of(timeout.intValue(), ChronoUnit.MILLIS)));
        return chatModelBuilder.build();
    }
}

