/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.output;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Response<T> {
    private final @NonNull T content;
    private final TokenUsage tokenUsage;
    private final FinishReason finishReason;
    private final @NonNull Map<String, Object> metadata;

    public Response(@NonNull T content) {
        this(content, null, null, Collections.emptyMap());
    }

    public Response(@NonNull T content, TokenUsage tokenUsage, FinishReason finishReason) {
        this(content, tokenUsage, finishReason, Collections.emptyMap());
    }

    public Response(@NonNull T content, TokenUsage tokenUsage, FinishReason finishReason, @Nullable Map<String, Object> metadata) {
        this.content = ValidationUtils.ensureNotNull(content, "content");
        this.tokenUsage = tokenUsage;
        this.finishReason = finishReason;
        this.metadata = metadata == null ? Collections.emptyMap() : new HashMap<String, Object>(metadata);
    }

    public @NonNull T content() {
        return this.content;
    }

    public TokenUsage tokenUsage() {
        return this.tokenUsage;
    }

    public FinishReason finishReason() {
        return this.finishReason;
    }

    public @NonNull Map<String, Object> metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response that = (Response)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.tokenUsage, that.tokenUsage) && Objects.equals((Object)this.finishReason, (Object)that.finishReason) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.tokenUsage, this.finishReason, this.metadata});
    }

    public String toString() {
        return "Response { content = " + String.valueOf(this.content) + ", tokenUsage = " + String.valueOf(this.tokenUsage) + ", finishReason = " + String.valueOf((Object)this.finishReason) + ", metadata = " + String.valueOf(this.metadata) + " }";
    }

    public static <T> @NonNull Response<T> from(@NonNull T content) {
        return new Response<T>(content);
    }

    public static <T> @NonNull Response<T> from(@NonNull T content, TokenUsage tokenUsage) {
        return new Response<T>(content, tokenUsage, null);
    }

    public static <T> @NonNull Response<T> from(@NonNull T content, TokenUsage tokenUsage, FinishReason finishReason) {
        return new Response<T>(content, tokenUsage, finishReason);
    }

    public static <T> @NonNull Response<T> from(@NonNull T content, TokenUsage tokenUsage, FinishReason finishReason, @Nullable Map<String, Object> metadata) {
        return new Response<T>(content, tokenUsage, finishReason, metadata);
    }
}

