/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai;

import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.bonitasoft.connectors.ai.AiConfiguration;
import org.bonitasoft.connectors.ai.AiConnectorException;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.langchain4j.BonitaDocumentSource;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AiConnector
extends AbstractConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AiConnector.class);
    public static final String OUTPUT = "output";
    protected AiConfiguration configuration;

    public void validateInputParameters() throws ConnectorValidationException {
        if (this.configuration == null) {
            AiConfiguration.AiConfigurationBuilder builder = AiConfiguration.builder();
            Optional.ofNullable(System.getenv("AI_API_KEY")).or(() -> Optional.ofNullable(System.getProperty("AI_API_KEY"))).or(() -> this.getInputValue("apiKey", String.class)).ifPresent(builder::apiKey);
            this.getInputValue("url", String.class).ifPresent(builder::baseUrl);
            this.getInputValue("chatModelName", String.class).ifPresent(builder::chatModelName);
            this.getInputValue("requestTimeoutMs", Integer.class).ifPresent(builder::requestTimeout);
            this.getInputValue("modelTemperature", Double.class).ifPresent(builder::modelTemperature);
            this.configuration = builder.build();
        }
        this.validateConfiguration();
    }

    protected abstract void validateConfiguration() throws ConnectorValidationException;

    protected void executeBusinessLogic() throws ConnectorException {
        Object aiResponse = this.doExecute();
        log.debug("Open AI connector output: {}", aiResponse);
        this.setOutputParameter(OUTPUT, aiResponse);
    }

    protected abstract Object doExecute() throws ConnectorException;

    protected UserDocument getUserDocument(String docRef) {
        long processInstanceId = this.getExecutionContext().getProcessInstanceId();
        ProcessAPI processAPI = this.getAPIAccessor().getProcessAPI();
        try {
            Document document = processAPI.getLastDocument(processInstanceId, docRef);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put(BonitaDocumentSource.Metadatas.FILE_NAME.name(), document.getContentFileName());
            metadata.put(BonitaDocumentSource.Metadatas.AUTHOR.name(), document.getAuthor());
            metadata.put(BonitaDocumentSource.Metadatas.MIME_TYPE.name(), document.getContentMimeType());
            metadata.put(BonitaDocumentSource.Metadatas.DESCRIPTION.name(), document.getDescription());
            metadata.put(BonitaDocumentSource.Metadatas.CREATION_DATE.name(), document.getCreationDate().toString());
            byte[] data = processAPI.getDocumentContent(document.getContentStorageId());
            return new UserDocument(document.getContentMimeType(), data, metadata);
        }
        catch (DocumentNotFoundException e) {
            throw new AiConnectorException("Document not found for ref: " + docRef, e);
        }
    }

    protected <T> Optional<T> getInputValue(String name, Class<T> type) {
        try {
            Object parameter = this.getInputParameter(name);
            T value = type.cast(parameter);
            return Optional.ofNullable(value);
        }
        catch (ClassCastException e) {
            throw new AiConnectorException(String.format("Parameter %s type must be a %s", name, type.getName()));
        }
    }

    @Generated
    public AiConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(AiConfiguration configuration) {
        this.configuration = configuration;
    }
}

