/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.classify;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bonitasoft.connectors.ai.AbstractAiChat;
import org.bonitasoft.connectors.ai.AiChat;
import org.bonitasoft.connectors.ai.AiConfiguration;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.classify.ClassifyChat;
import org.bonitasoft.connectors.utils.AiResponse;
import org.bonitasoft.connectors.utils.IOs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassifyAiChat<T extends ChatLanguageModel>
extends AbstractAiChat<T>
implements AiChat<T>,
ClassifyChat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassifyAiChat.class);
    protected String systemPrompt;
    protected String userPrompt;
    protected final AiConfiguration configuration;

    protected ClassifyAiChat(AiConfiguration configuration) {
        this.configuration = configuration;
        this.systemPrompt = IOs.readAsString("/prompt/classify/system.txt");
        this.userPrompt = IOs.readAsString("/prompt/classify/user.txt");
    }

    @Override
    public AiConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String classify(List<String> categories, UserDocument document) {
        ArrayList<Object> messages = new ArrayList<Object>();
        SystemMessage systemMessage = SystemMessage.from((String)this.systemPrompt);
        messages.add(systemMessage);
        String categoriesForPrompt = String.join((CharSequence)"\n   - ", categories);
        Prompt prompt = PromptTemplate.from((String)this.userPrompt).apply(Map.of("categories", categoriesForPrompt));
        UserMessage userMessage = prompt.toUserMessage();
        messages.add(userMessage);
        ChatMessage docMessage = this.newDocMessage(document);
        messages.add(docMessage);
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        ChatResponse chatResponse = this.getChatModel().chat(chatRequest);
        return AiResponse.ensureJson(chatResponse.aiMessage().text());
    }
}

