/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.extract;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bonitasoft.connectors.ai.AiConnector;
import org.bonitasoft.connectors.ai.AiConnectorException;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.extract.ExtractChat;
import org.bonitasoft.connectors.ai.extract.ExtractConfiguration;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtractAiConnector<T extends ExtractChat>
extends AiConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractAiConnector.class);
    protected ExtractConfiguration extractConfiguration;
    protected T chat;

    @Override
    protected void validateConfiguration() throws ConnectorValidationException {
        ExtractConfiguration.ExtractConfigurationBuilder builder = ExtractConfiguration.builder();
        this.getInputValue("sourceDocumentRef", String.class).ifPresent(builder::sourceDocumentRef);
        this.getInputValue("outputJsonSchema", String.class).ifPresent(builder::outputJsonSchema);
        this.getInputValue("fieldsToExtract", List.class).ifPresent(builder::fieldsToExtract);
        this.extractConfiguration = builder.build();
        if (this.extractConfiguration.getSourceDocumentRef().isEmpty()) {
            throw new ConnectorValidationException("Source document ref is empty");
        }
        if (this.extractConfiguration.getFieldsToExtract().isEmpty() && this.extractConfiguration.getOutputJsonSchema().isEmpty()) {
            throw new ConnectorValidationException("Either field list or a jsonschema must be provided");
        }
    }

    @Override
    protected Object doExecute() throws ConnectorException {
        UserDocument userDocument = this.getUserDocument(this.extractConfiguration.getSourceDocumentRef());
        Optional<String> output = this.extractConfiguration.getOutputJsonSchema().map(jsonSchema -> this.chat.extract(userDocument, (String)jsonSchema)).or(() -> this.extractConfiguration.getFieldsToExtract().map(fields -> this.chat.extract(userDocument, (List<String>)fields)));
        return output.orElseThrow(() -> new AiConnectorException("Fields to extract or JSON schema is missing."));
    }
}

