/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.hemf.record.emf.HemfComment;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hemf.record.emf.HemfText;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.util.StringUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EMFParser
implements Parser {
    public static Property EMF_ICON_ONLY = Property.internalBoolean((String)"emf:iconOnly");
    public static Property EMF_ICON_STRING = Property.internalText((String)"emf:iconString");
    private static String ICON_ONLY = "IconOnly";
    private static final MediaType MEDIA_TYPE = MediaType.image((String)"emf");
    private static final MediaType WMF_MEDIA_TYPE = MediaType.image((String)"wmf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    private static void handleEmbedded(byte[] data, EmbeddedDocumentExtractor embeddedDocumentExtractor, ContentHandler handler) throws TikaException, SAXException {
        try (TikaInputStream is = TikaInputStream.get((byte[])data);){
            Metadata embeddedMetadata = new Metadata();
            if (embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
                embeddedDocumentExtractor.parseEmbedded((InputStream)is, (ContentHandler)new EmbeddedContentHandler(handler), embeddedMetadata, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Object embeddedDocumentExtractor = null;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            HemfPicture ex = new HemfPicture(stream);
            ParseState parseState = new ParseState();
            long fudgeFactorX = 1000L;
            StringBuilder buffer = new StringBuilder();
            for (HemfRecord record : ex) {
                parseState.isIconOnly = false;
                if (record.getEmfRecordType() == HemfRecordType.comment) {
                    this.handleCommentData(((HemfComment.EmfComment)record).getCommentData(), parseState, xhtml, context);
                } else if (record.getEmfRecordType().equals((Object)HemfRecordType.extTextOutW)) {
                    HemfText.EmfExtTextOutW extTextOutW = (HemfText.EmfExtTextOutW)record;
                    if (parseState.lastY > -1.0 && parseState.lastY != extTextOutW.getReference().getY()) {
                        xhtml.startElement("p");
                        xhtml.characters(buffer.toString());
                        xhtml.endElement("p");
                        buffer.setLength(0);
                        parseState.lastX = -1.0;
                    }
                    if (parseState.lastX > -1.0 && extTextOutW.getReference().getX() - parseState.lastX > (double)fudgeFactorX) {
                        buffer.append(" ");
                    }
                    String txt = extTextOutW.getText();
                    buffer.append(txt);
                    parseState.lastY = extTextOutW.getReference().getY();
                    parseState.lastX = extTextOutW.getReference().getX();
                }
                if (parseState.isIconOnly) {
                    parseState.lastWasIconOnly = true;
                    continue;
                }
                parseState.lastWasIconOnly = false;
            }
            if (parseState.iconOnlyString != null) {
                metadata.set(EMF_ICON_ONLY, true);
                metadata.set(EMF_ICON_STRING, parseState.iconOnlyString);
            }
            if (buffer.length() > 0) {
                xhtml.startElement("p");
                xhtml.characters(buffer.toString());
                xhtml.endElement("p");
            }
        }
        catch (RecordFormatException e) {
            throw new TikaException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new TikaException(e.getMessage(), (Throwable)e);
        }
        xhtml.endDocument();
    }

    private void handleCommentData(HemfComment.EmfCommentData commentData, ParseState parseState, XHTMLContentHandler xhtml, ParseContext context) throws IOException, TikaException, SAXException {
        if (commentData instanceof HemfComment.EmfCommentDataMultiformats) {
            if (parseState.extractor == null) {
                parseState.extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
            }
            this.handleMultiFormats((HemfComment.EmfCommentDataMultiformats)commentData, (ContentHandler)xhtml, parseState.extractor);
        } else if (commentData instanceof HemfComment.EmfCommentDataWMF) {
            if (parseState.extractor == null) {
                parseState.extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
            }
            this.handleWMF(((HemfComment.EmfCommentDataWMF)commentData).getWMFData(), (ContentHandler)xhtml, parseState.extractor);
        } else if (commentData instanceof HemfComment.EmfCommentDataGeneric) {
            String val = this.tryToReadAsString(((HemfComment.EmfCommentDataGeneric)commentData).getPrivateData());
            if (ICON_ONLY.equals(val) && !parseState.hitIconOnly) {
                parseState.hitIconOnly = true;
                parseState.isIconOnly = true;
            } else if (parseState.lastWasIconOnly && parseState.iconOnlyString == null) {
                parseState.iconOnlyString = val;
            }
        }
    }

    private String tryToReadAsString(byte[] bytes) {
        if (bytes.length < 2) {
            return null;
        }
        int stringLen = (bytes.length - 2) / 2;
        try {
            return StringUtil.getFromUnicodeLE0Terminated((byte[])bytes, (int)0, (int)stringLen);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void handleWMF(byte[] bytes, ContentHandler contentHandler, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, SAXException, TikaException {
        Metadata embeddedMetadata = new Metadata();
        embeddedMetadata.set("Content-Type", WMF_MEDIA_TYPE.toString());
        if (embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            try (TikaInputStream is = TikaInputStream.get((byte[])bytes);){
                embeddedDocumentExtractor.parseEmbedded((InputStream)is, (ContentHandler)new EmbeddedContentHandler(contentHandler), embeddedMetadata, true);
            }
        }
    }

    private void handleMultiFormats(HemfComment.EmfCommentDataMultiformats commentData, ContentHandler handler, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, TikaException, SAXException {
        for (HemfComment.EmfCommentDataFormat dataFormat : commentData.getFormats()) {
            EMFParser.handleEmbedded(dataFormat.getRawData(), embeddedDocumentExtractor, handler);
        }
    }

    private static class ParseState {
        double lastY = -1.0;
        double lastX = -1.0;
        boolean hitIconOnly = false;
        boolean lastWasIconOnly = false;
        boolean isIconOnly = false;
        String iconOnlyString = null;
        EmbeddedDocumentExtractor extractor;

        private ParseState() {
        }
    }
}

