/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.ask;

import lombok.Generated;
import org.bonitasoft.connectors.ai.AiConnector;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.ask.AskChat;
import org.bonitasoft.connectors.ai.ask.AskConfiguration;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AskAiConnector
extends AiConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AskAiConnector.class);
    protected AskConfiguration askConfiguration;
    protected AskChat chat;

    @Override
    protected void validateConfiguration() throws ConnectorValidationException {
        AskConfiguration.AskConfigurationBuilder builder = AskConfiguration.builder();
        this.getInputValue("systemPrompt", String.class).ifPresent(builder::systemPrompt);
        this.getInputValue("userPrompt", String.class).ifPresent(builder::userPrompt);
        this.getInputValue("sourceDocumentRef", String.class).ifPresent(builder::sourceDocumentRef);
        this.getInputValue("outputJsonSchema", String.class).ifPresent(builder::outputJsonSchema);
        this.askConfiguration = builder.build();
        if (this.askConfiguration.getUserPrompt() == null) {
            throw new ConnectorValidationException("UserPrompt is required");
        }
        if (this.askConfiguration.getUserPrompt().isBlank()) {
            throw new ConnectorValidationException("UserPrompt is blank or empty");
        }
    }

    @Override
    protected Object doExecute() throws ConnectorException {
        UserDocument userDocument = this.askConfiguration.getSourceDocumentRef().map(x$0 -> this.getUserDocument((String)x$0)).orElse(null);
        return this.chat.ask(this.askConfiguration.getSystemPrompt(), this.askConfiguration.getUserPrompt(), this.askConfiguration.getOutputJsonSchema().orElse(null), userDocument);
    }
}

