/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ai.classify;

import java.util.List;
import org.bonitasoft.connectors.ai.AiConnector;
import org.bonitasoft.connectors.ai.UserDocument;
import org.bonitasoft.connectors.ai.classify.ClassifyChat;
import org.bonitasoft.connectors.ai.classify.ClassifyConfiguration;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class ClassifyAiConnector<T extends ClassifyChat>
extends AiConnector {
    protected ClassifyConfiguration classifyConfiguration;
    protected T chat;

    @Override
    protected void validateConfiguration() throws ConnectorValidationException {
        if (this.classifyConfiguration == null) {
            ClassifyConfiguration.ClassifyConfigurationBuilder builder = ClassifyConfiguration.builder();
            this.getInputValue("sourceDocumentRef", String.class).ifPresent(builder::sourceDocumentRef);
            this.getInputValue("categories", List.class).ifPresent(builder::categories);
            this.classifyConfiguration = builder.build();
        }
        if (this.classifyConfiguration.getSourceDocumentRef() == null || this.classifyConfiguration.getSourceDocumentRef().isEmpty()) {
            throw new ConnectorValidationException("Source document ref is empty");
        }
        if (this.classifyConfiguration.getCategories() == null || this.classifyConfiguration.getCategories().isEmpty()) {
            throw new ConnectorValidationException("Classification categories are empty");
        }
    }

    @Override
    protected Object doExecute() {
        UserDocument userDocument = this.getUserDocument(this.classifyConfiguration.getSourceDocumentRef());
        return this.chat.classify(this.classifyConfiguration.getCategories(), userDocument);
    }
}

