/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.TypeUtils;
import dev.langchain4j.service.output.DefaultOutputParserFactory;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.OutputParserFactory;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;

public class ServiceOutputParser {
    private final OutputParserFactory outputParserFactory;

    public ServiceOutputParser() {
        this(new DefaultOutputParserFactory());
    }

    ServiceOutputParser(OutputParserFactory outputParserFactory) {
        this.outputParserFactory = (OutputParserFactory)ValidationUtils.ensureNotNull((Object)outputParserFactory, (String)"outputParserFactory");
    }

    public Object parse(Response<AiMessage> response, Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterType(returnType);
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        Class<?> typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType);
        if (rawClass == Response.class) {
            return response;
        }
        AiMessage aiMessage = (AiMessage)response.content();
        if (rawClass == AiMessage.class) {
            return aiMessage;
        }
        String text = aiMessage.text();
        if (rawClass == String.class) {
            return text;
        }
        OutputParser<?> outputParser = this.outputParserFactory.get(rawClass, typeArgumentClass);
        return outputParser.parse(text);
    }

    public Optional<JsonSchema> jsonSchema(Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterType(returnType);
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        Class<?> typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType);
        if (ServiceOutputParser.schemaNotRequired(rawClass)) {
            return Optional.empty();
        }
        if (returnType == Void.TYPE) {
            throw IllegalConfigurationException.illegalConfiguration("Return type of method '%s' cannot be void");
        }
        OutputParser<?> outputParser = this.outputParserFactory.get(rawClass, typeArgumentClass);
        return outputParser.jsonSchema();
    }

    public String outputFormatInstructions(Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterType(returnType);
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        Class<?> typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType);
        if (ServiceOutputParser.schemaNotRequired(rawClass)) {
            return "";
        }
        if (returnType == Void.TYPE) {
            throw IllegalConfigurationException.illegalConfiguration("Return type of method '%s' cannot be void");
        }
        OutputParser<?> outputParser = this.outputParserFactory.get(rawClass, typeArgumentClass);
        Object formatInstructions = outputParser.formatInstructions();
        if (!((String)formatInstructions).startsWith("\nYou must")) {
            formatInstructions = "\nYou must answer strictly in the following format: " + (String)formatInstructions;
        }
        return formatInstructions;
    }

    private static boolean schemaNotRequired(Class<?> type) {
        return type == String.class || type == AiMessage.class || type == TokenStream.class || type == Response.class || type == Map.class;
    }
}

