/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.bonitasoft.engine.connector.ConnectorException;

public class Database {
    private final Connection connection;
    private Context ctx;
    private Statement selectStatement;

    public Database(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(driver);
        this.connection = DriverManager.getConnection(url, username, password);
    }

    public Database(String dataSource, Properties properties) throws NamingException, SQLException {
        this.ctx = new InitialContext(properties);
        DataSource ds = (DataSource)this.ctx.lookup(dataSource);
        this.connection = ds.getConnection();
    }

    public void disconnect() throws SQLException, NamingException {
        if (this.selectStatement != null) {
            this.selectStatement.close();
            this.selectStatement = null;
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    public ResultSet select(String query) throws ConnectorException, SQLException {
        if (this.selectStatement != null) {
            throw new ConnectorException("A Statement is already opened.");
        }
        this.selectStatement = this.connection.createStatement(1004, 1007);
        return this.selectStatement.executeQuery(query);
    }

    public boolean executeCommand(String command) throws SQLException, ConnectorException {
        boolean isExecuted = false;
        try (Statement statement = null;){
            statement = this.connection.createStatement(1004, 1007);
            isExecuted = statement.execute(command);
        }
        return isExecuted;
    }

    public void executeBatch(List<String> commands, boolean commit) throws SQLException, ConnectorException {
        try (Statement statement = null;){
            this.connection.setAutoCommit(false);
            statement = this.connection.createStatement();
            for (String command : commands) {
                statement.addBatch(command);
            }
            statement.executeBatch();
            if (commit) {
                this.connection.commit();
            }
        }
    }
}

