/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ldap;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.bonitasoft.connectors.ldap.LdapAttribute;
import org.bonitasoft.connectors.ldap.LdapDereferencingAlias;
import org.bonitasoft.connectors.ldap.LdapProtocol;
import org.bonitasoft.connectors.ldap.LdapScope;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnector
extends AbstractConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapConnector.class);
    public static final String HOST_PARAMETER = "host";
    public static final String PORT_PARAMETER = "port";
    public static final String PROTOCOL_PARAMETER = "protocol";
    public static final String USERNAME_PARAMETER = "username";
    public static final String PASSWORD_PARAMETER = "password";
    public static final String BASE_OBJECT_PARAMETER = "baseObject";
    public static final String SCOPE_PARAMETER = "scope";
    public static final String FILTER_PARAMETER = "filter";
    public static final String ATTRIBUTES_PARAMETER = "attributes";
    public static final String SIZE_LIMIT_PARAMETER = "sizeLimit";
    public static final String PAGE_SIZE_PARAMETER = "pageSize";
    public static final String TIME_LIMIT_PARAMETER = "timeLimit";
    public static final String REFERRAL_HANDLING_PARAMETER = "referralHandling";
    public static final String DEREF_ALIASES_PARAMETER = "derefAliases";
    public static final String LDAP_ATTRIBUTE_LIST_OUTPUT = "ldapAttributeList";
    private String host;
    private int port = 389;
    private LdapProtocol protocol;
    private String userName;
    private String password;
    private String certificatePath;
    private String baseObject;
    private LdapScope scope = LdapScope.BASE;
    private String filter;
    private LdapDereferencingAlias derefAliases = LdapDereferencingAlias.ALWAYS;
    private String[] attributes;
    private Long sizeLimit = 0L;
    private Long pageSize = 0L;
    private Integer timeLimit = 0;
    private String referralHandling = "ignore";
    private List<List<LdapAttribute>> result = new ArrayList<List<LdapAttribute>>();

    private String getHost() {
        return this.host;
    }

    private Integer getPort() {
        return this.port;
    }

    public LdapProtocol getProtocol() {
        return this.protocol;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public String getBaseObject() {
        return this.baseObject;
    }

    public LdapScope getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }

    public LdapDereferencingAlias getDerefAliases() {
        return this.derefAliases;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public List<List<LdapAttribute>> getLdapAttributeList() {
        return this.result;
    }

    public String getReferralHandling() {
        return this.referralHandling;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Long port) {
        if (port == null) {
            this.setPort(Integer.MIN_VALUE);
        } else {
            this.setPort(port.intValue());
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(LdapProtocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = LdapProtocol.LDAPS;
        if (protocol != null) {
            if ((protocol = protocol.toUpperCase()).equals(LdapProtocol.TLS.toString())) {
                this.protocol = LdapProtocol.TLS;
            } else if (protocol.equals(LdapProtocol.LDAP.toString())) {
                this.protocol = LdapProtocol.LDAP;
            }
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBaseObject(String baseObject) {
        this.baseObject = baseObject;
    }

    public void setScope(LdapScope scope) {
        this.scope = scope;
    }

    public void setScope(String scope) {
        this.scope = LdapScope.ONELEVEL;
        if (scope != null) {
            if ((scope = scope.toUpperCase()).equals(LdapScope.BASE.toString())) {
                this.scope = LdapScope.BASE;
            } else if (scope.equals(LdapScope.SUBTREE.toString())) {
                this.scope = LdapScope.SUBTREE;
            }
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setDerefAliases(LdapDereferencingAlias derefAliases) {
        this.derefAliases = derefAliases;
    }

    public void setDerefAliases(String derefAliases) {
        if (derefAliases != null && !derefAliases.isEmpty()) {
            this.derefAliases = LdapDereferencingAlias.valueOf(derefAliases.toUpperCase());
        }
    }

    public void setAttributes(String[] attributes) {
        if (attributes == null) {
            this.attributes = null;
        } else {
            this.attributes = new String[attributes.length];
            System.arraycopy(attributes, 0, this.attributes, 0, attributes.length);
        }
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes == null || "".equals(attributes.trim()) ? null : (String[])Stream.of(attributes.split(",")).map(String::trim).toArray(String[]::new);
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public void setSizeLimit(Long sizeLimit) {
        if (sizeLimit == null) {
            this.setSizeLimit(Long.MIN_VALUE);
        } else {
            this.setSizeLimit((long)sizeLimit);
        }
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageSize(Long pageSize) {
        if (pageSize == null) {
            this.setPageSize(Long.MIN_VALUE);
        } else {
            this.setPageSize((long)pageSize);
        }
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void setTimeLimit(Long timeLimit) {
        if (timeLimit == null) {
            this.setTimeLimit(Integer.MIN_VALUE);
        } else {
            this.setTimeLimit(timeLimit.intValue());
        }
    }

    public void setReferralHandling(String referralHandling) {
        this.referralHandling = referralHandling;
    }

    public void setInputParameters(Map<String, Object> parameters) {
        this.setHost((String)parameters.get(HOST_PARAMETER));
        this.setPort((Integer)parameters.get(PORT_PARAMETER));
        this.setProtocol((String)parameters.get(PROTOCOL_PARAMETER));
        this.setUserName((String)parameters.get(USERNAME_PARAMETER));
        this.setPassword((String)parameters.get(PASSWORD_PARAMETER));
        this.setBaseObject((String)parameters.get(BASE_OBJECT_PARAMETER));
        this.setScope((String)parameters.get(SCOPE_PARAMETER));
        this.setFilter((String)parameters.get(FILTER_PARAMETER));
        this.setAttributes((String)parameters.get(ATTRIBUTES_PARAMETER));
        this.setSizeLimit((Long)parameters.get(SIZE_LIMIT_PARAMETER));
        this.setPageSize((Long)parameters.get(PAGE_SIZE_PARAMETER));
        this.setTimeLimit((Long)parameters.get(TIME_LIMIT_PARAMETER));
        this.setReferralHandling((String)parameters.get(REFERRAL_HANDLING_PARAMETER));
        this.setDerefAliases((String)parameters.get(DEREF_ALIASES_PARAMETER));
    }

    private Hashtable<String, String> getEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", "ldap://" + this.getHost() + ":" + this.getPort());
        if (this.getProtocol().equals((Object)LdapProtocol.LDAPS)) {
            environment.put("java.naming.security.protocol", "ssl");
        }
        if (!LdapProtocol.TLS.equals((Object)this.getProtocol()) && this.getUserName() != null && this.getPassword() != null) {
            environment.put("java.naming.security.authentication", "simple");
            environment.put("java.naming.security.principal", this.getUserName());
            environment.put("java.naming.security.credentials", this.getPassword());
        } else {
            environment.put("java.naming.security.authentication", "none");
        }
        environment.put("java.naming.ldap.derefAliases", this.getDerefAliases().toString().toLowerCase());
        environment.put("java.naming.referral", this.getReferralHandling());
        return environment;
    }

    protected void executeBusinessLogic() throws ConnectorException {
        InitialLdapContext ctx;
        Hashtable<String, String> env = this.getEnvironment();
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
        StartTlsResponse response = null;
        try {
            if (LdapProtocol.TLS.equals((Object)this.getProtocol())) {
                StartTlsRequest request = new StartTlsRequest();
                response = (StartTlsResponse)ctx.extendedOperation(request);
                response.negotiate();
                if (this.getUserName() != null && this.getPassword() != null) {
                    ctx.addToEnvironment("java.naming.security.authentication", "simple");
                    ctx.addToEnvironment("java.naming.security.principal", this.getUserName());
                    ctx.addToEnvironment("java.naming.security.credentials", this.getPassword());
                }
            }
            SearchControls ctls = new SearchControls();
            ctls.setTimeLimit(this.getTimeLimit() * 1000);
            ctls.setCountLimit(this.getSizeLimit());
            ctls.setReturningAttributes(this.getAttributes());
            ctls.setSearchScope(this.getScope().value());
            if (this.getPageSize() > 0L) {
                this.doPagedSearch(ctx, ctls);
            } else {
                this.doNonPagedSearch(ctx, ctls);
            }
            this.setOutputParameter(LDAP_ATTRIBUTE_LIST_OUTPUT, this.result);
        }
        catch (IOException | NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing the StartTlsResponse", (Throwable)e);
                }
            }
            try {
                ctx.close();
            }
            catch (NamingException e) {
                LOGGER.error("Error closing the LDAP context", (Throwable)e);
            }
        }
    }

    private void addSearchResult(SearchResult sr) throws NamingException {
        Attributes attribs = sr.getAttributes();
        NamingEnumeration<? extends Attribute> enume = attribs.getAll();
        ArrayList<LdapAttribute> elements = new ArrayList<LdapAttribute>();
        while (enume.hasMore()) {
            Attribute attribute = enume.next();
            NamingEnumeration<?> all = attribute.getAll();
            while (all.hasMore()) {
                Object key = all.next();
                String value = key instanceof byte[] ? new String((byte[])key, StandardCharsets.UTF_8) : key.toString();
                elements.add(new LdapAttribute(attribute.getID(), value));
            }
        }
        if (!elements.isEmpty()) {
            this.result.add(elements);
        }
    }

    private void doNonPagedSearch(LdapContext ctx, SearchControls ctls) throws NamingException {
        NamingEnumeration<SearchResult> answer = ctx.search(this.getBaseObject(), this.getFilter(), ctls);
        long count = this.getSizeLimit();
        if (count == 0L) {
            count = Long.MAX_VALUE;
        }
        this.result = new ArrayList<List<LdapAttribute>>();
        while (count > 0L && answer.hasMore()) {
            SearchResult sr = answer.next();
            --count;
            this.addSearchResult(sr);
        }
    }

    private void doPagedSearch(LdapContext ctx, SearchControls ctls) throws NamingException, IOException {
        this.result = new ArrayList<List<LdapAttribute>>();
        byte[] cookie = null;
        ctx.setRequestControls(new Control[]{new PagedResultsControl((int)this.getPageSize(), false)});
        do {
            NamingEnumeration<SearchResult> answer = ctx.search(this.getBaseObject(), this.getFilter(), ctls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                this.addSearchResult(sr);
            }
            Control[] controls = ctx.getResponseControls();
            if (controls != null) {
                for (Control control : controls) {
                    if (!(control instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                    cookie = prrc.getCookie();
                }
            }
            ctx.setRequestControls(new Control[]{new PagedResultsControl((int)this.getPageSize(), cookie, true)});
        } while (cookie != null);
    }

    public void validateInputParameters() throws ConnectorValidationException {
        File temp;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.host == null || this.host.length() == 0) {
            errors.add("host cannot be empty!");
        }
        if (this.userName == null || this.userName.length() == 0) {
            if (this.password != null && this.password.length() != 0) {
                errors.add("username cannot be empty!");
            }
        } else if (this.password == null || this.password.length() == 0) {
            errors.add("password cannot be empty!");
        }
        if (this.baseObject == null || this.baseObject.length() == 0) {
            errors.add("baseObject cannot be empty!");
        }
        if (this.filter == null || this.filter.length() == 0) {
            errors.add("filter cannot be empty!");
        }
        if (this.port < 0) {
            errors.add("port cannot be less than 0!");
        } else if (this.getPort() > 65535) {
            errors.add("port cannot be greater than 65535!");
        }
        if (this.protocol == null) {
            errors.add("protocol cannot be null");
        } else {
            switch (this.getProtocol()) {
                case LDAP: 
                case LDAPS: 
                case TLS: {
                    break;
                }
                default: {
                    errors.add("Unknown protocol");
                }
            }
        }
        if (this.scope == null) {
            errors.add("scope cannot be null");
        } else {
            switch (this.getScope()) {
                case BASE: 
                case ONELEVEL: 
                case SUBTREE: {
                    break;
                }
                default: {
                    errors.add("Unknown scope");
                }
            }
        }
        if (this.getCertificatePath() != null && !(temp = new File(this.certificatePath)).exists()) {
            errors.add("Certificate path does not refer to a real file!");
        }
        if (this.sizeLimit == null || this.sizeLimit < 0L) {
            errors.add("sizeLimit cannot be null or negative");
        }
        if (this.timeLimit == null || this.getTimeLimit() < 0) {
            errors.add("timeLimit cannot be null or negative");
        }
        if (this.getReferralHandling() == null) {
            errors.add("referralHandling is null!");
        } else if (!this.getReferralHandling().equals("ignore") && !this.getReferralHandling().equals("follow")) {
            errors.add("referralHandling must be either ignore or follow!");
        }
        String derefAliasesInput = (String)this.getInputParameter(DEREF_ALIASES_PARAMETER);
        if (derefAliasesInput != null && !derefAliasesInput.isEmpty()) {
            try {
                LdapDereferencingAlias.valueOf(derefAliasesInput);
            }
            catch (IllegalArgumentException e) {
                throw new ConnectorValidationException(String.format("%s is not a valid dereferencing alias.", derefAliasesInput));
            }
        }
        if (!errors.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, errors);
        }
    }
}

