/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bonitasoft.connectors.rest.model.AuthorizationType;
import org.bonitasoft.connectors.rest.model.SSLVerifier;
import org.bonitasoft.connectors.rest.model.TrustCertificateStrategy;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public abstract class AbstractRESTConnectorImpl
extends AbstractConnector {
    protected static final String URL_INPUT_PARAMETER = "url";
    protected static final String METHOD_INPUT_PARAMETER = "method";
    protected static final String CONTENTTYPE_INPUT_PARAMETER = "contentType";
    protected static final String CHARSET_INPUT_PARAMETER = "charset";
    protected static final String URLCOOKIES_INPUT_PARAMETER = "urlCookies";
    protected static final String URLHEADERS_INPUT_PARAMETER = "urlHeaders";
    protected static final String BODY_INPUT_PARAMETER = "body";
    protected static final String DO_NOT_FOLLOW_REDIRECT_INPUT_PARAMETER = "do_not_follow_redirect";
    protected static final String IGNORE_BODY_INPUT_PARAMETER = "ignore_body";
    protected static final String TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER = "trust_strategy";
    protected static final String TLS_INPUT_PARAMETER = "TLS";
    protected static final String HOSTNAME_VERIFIER_INPUT_PARAMETER = "hostname_verifier";
    protected static final String TRUST_STORE_FILE_INPUT_PARAMETER = "trust_store_file";
    protected static final String TRUST_STORE_PASSWORD_INPUT_PARAMETER = "trust_store_password";
    protected static final String KEY_STORE_FILE_INPUT_PARAMETER = "key_store_file";
    protected static final String KEY_STORE_PASSWORD_INPUT_PARAMETER = "key_store_password";
    protected static final String AUTH_TYPE_PARAMETER = "auth_type";
    protected static final String AUTH_USERNAME_INPUT_PARAMETER = "auth_username";
    protected static final String AUTH_PASSWORD_INPUT_PARAMETER = "auth_password";
    protected static final String AUTH_HOST_INPUT_PARAMETER = "auth_host";
    protected static final String AUTH_PORT_INPUT_PARAMETER = "auth_port";
    protected static final String AUTH_REALM_INPUT_PARAMETER = "auth_realm";
    protected static final String AUTH_PREEMPTIVE_INPUT_PARAMETER = "auth_preemptive";
    protected static final String PROXY_PROTOCOL_INPUT_PARAMETER = "proxy_protocol";
    protected static final String PROXY_HOST_INPUT_PARAMETER = "proxy_host";
    protected static final String PROXY_PORT_INPUT_PARAMETER = "proxy_port";
    protected static final String PROXY_USERNAME_INPUT_PARAMETER = "proxy_username";
    protected static final String PROXY_PASSWORD_INPUT_PARAMETER = "proxy_password";
    protected static final String BODY_AS_STRING_OUTPUT_PARAMETER = "bodyAsString";
    protected static final String BODY_AS_OBJECT_OUTPUT_PARAMETER = "bodyAsObject";
    protected static final String HEADERS_OUTPUT_PARAMETER = "headers";
    protected static final String STATUS_CODE_OUTPUT_PARAMETER = "status_code";
    protected static final String STATUS_MESSAGE_OUTPUT_PARAMETER = "status_message";
    protected static final String SOCKET_TIMEOUT_MS_PARAMETER = "socket_timeout_ms";
    protected static final String CONNECTION_TIMEOUT_MS_PARAMETER = "connection_timeout_ms";
    protected static final int SOCKET_TIMEOUT_MS_DEFAULT_VALUE = 60000;
    protected static final int CONNECTION_TIMEOUT_MS_DEFAULT_VALUE = 60000;

    protected final String getUrl() {
        return (String)this.getInputParameter(URL_INPUT_PARAMETER);
    }

    protected String getMethod() {
        return (String)this.getInputParameter(METHOD_INPUT_PARAMETER);
    }

    protected final String getContentType() {
        return (String)this.getInputParameter(CONTENTTYPE_INPUT_PARAMETER);
    }

    protected final String getCharset() {
        return (String)this.getInputParameter(CHARSET_INPUT_PARAMETER);
    }

    protected final List getUrlCookies() {
        List cookies = (List)this.getInputParameter(URLCOOKIES_INPUT_PARAMETER);
        if (cookies == null) {
            cookies = Collections.emptyList();
        }
        cookies.removeIf(this.emptyLines());
        return cookies;
    }

    private Predicate<Object> emptyLines() {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                if (input instanceof List) {
                    List line = (List)input;
                    return line.size() != 2 || this.emptyCell(line, 0) && this.emptyCell(line, 1);
                }
                return true;
            }

            private boolean emptyCell(List line, int cellIndex) {
                Object cellValue = line.get(cellIndex);
                return cellValue == null || cellValue.toString().trim().isEmpty();
            }
        };
    }

    protected final List getUrlHeaders() {
        List headers = (List)this.getInputParameter(URLHEADERS_INPUT_PARAMETER);
        if (headers == null) {
            headers = Collections.emptyList();
        }
        headers.removeIf(this.emptyLines());
        return headers;
    }

    protected final String getBody() {
        return (String)this.getInputParameter(BODY_INPUT_PARAMETER);
    }

    protected final Boolean getTLS() {
        Boolean tlsParam = (Boolean)this.getInputParameter(TLS_INPUT_PARAMETER);
        return tlsParam != null ? tlsParam : Boolean.TRUE;
    }

    protected final TrustCertificateStrategy getTrustCertificateStrategy() {
        String trustParam = (String)this.getInputParameter(TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER);
        if (trustParam != null && !trustParam.trim().isEmpty()) {
            return TrustCertificateStrategy.valueOf(trustParam);
        }
        return TrustCertificateStrategy.DEFAULT;
    }

    protected final SSLVerifier getHostnameVerifier() {
        String hostanmeVerifierParam = (String)this.getInputParameter(HOSTNAME_VERIFIER_INPUT_PARAMETER);
        if (hostanmeVerifierParam != null && !hostanmeVerifierParam.trim().isEmpty()) {
            return SSLVerifier.getSSLVerifierFromValue(hostanmeVerifierParam.toUpperCase());
        }
        return SSLVerifier.STRICT;
    }

    protected final String getTrustStoreFile() {
        return (String)this.getInputParameter(TRUST_STORE_FILE_INPUT_PARAMETER);
    }

    protected final String getTrustStorePassword() {
        return (String)this.getInputParameter(TRUST_STORE_PASSWORD_INPUT_PARAMETER);
    }

    protected final String getKeyStoreFile() {
        return (String)this.getInputParameter(KEY_STORE_FILE_INPUT_PARAMETER);
    }

    protected final String getKeyStorePassword() {
        return (String)this.getInputParameter(KEY_STORE_PASSWORD_INPUT_PARAMETER);
    }

    protected final Boolean getDoNotFollowRedirect() {
        Boolean follozRedirect = (Boolean)this.getInputParameter(DO_NOT_FOLLOW_REDIRECT_INPUT_PARAMETER);
        return follozRedirect != null ? follozRedirect : Boolean.FALSE;
    }

    protected final Boolean getIgnoreBody() {
        Boolean ignoreBody = (Boolean)this.getInputParameter(IGNORE_BODY_INPUT_PARAMETER);
        return ignoreBody != null ? ignoreBody : Boolean.FALSE;
    }

    protected final String getAuthUsername() {
        return (String)this.getInputParameter(AUTH_USERNAME_INPUT_PARAMETER);
    }

    protected final String getAuthPassword() {
        return (String)this.getInputParameter(AUTH_PASSWORD_INPUT_PARAMETER);
    }

    protected final String getAuthHost() {
        return (String)this.getInputParameter(AUTH_HOST_INPUT_PARAMETER);
    }

    protected final Integer getAuthPort() {
        return (Integer)this.getInputParameter(AUTH_PORT_INPUT_PARAMETER);
    }

    protected final String getAuthRealm() {
        return (String)this.getInputParameter(AUTH_REALM_INPUT_PARAMETER);
    }

    protected final Boolean getAuthPreemptive() {
        Boolean preemptive = (Boolean)this.getInputParameter(AUTH_PREEMPTIVE_INPUT_PARAMETER);
        return preemptive != null ? preemptive : Boolean.TRUE;
    }

    protected final AuthorizationType getAuthType() {
        String authType = (String)this.getInputParameter(AUTH_TYPE_PARAMETER);
        return authType != null ? AuthorizationType.valueOf(authType) : AuthorizationType.NONE;
    }

    protected final String getProxyProtocol() {
        return (String)this.getInputParameter(PROXY_PROTOCOL_INPUT_PARAMETER);
    }

    protected final String getProxyHost() {
        return (String)this.getInputParameter(PROXY_HOST_INPUT_PARAMETER);
    }

    protected final Integer getProxyPort() {
        return (Integer)this.getInputParameter(PROXY_PORT_INPUT_PARAMETER);
    }

    protected final String getProxyUsername() {
        return (String)this.getInputParameter(PROXY_USERNAME_INPUT_PARAMETER);
    }

    protected final String getProxyPassword() {
        return (String)this.getInputParameter(PROXY_PASSWORD_INPUT_PARAMETER);
    }

    protected final Integer getSocketTimeoutMs() {
        Integer socketTimeoutMs = (Integer)this.getInputParameter(SOCKET_TIMEOUT_MS_PARAMETER);
        return socketTimeoutMs != null ? socketTimeoutMs : 60000;
    }

    protected final Integer getConnectionTimeoutMs() {
        Integer connectionTimeoutMs = (Integer)this.getInputParameter(CONNECTION_TIMEOUT_MS_PARAMETER);
        return connectionTimeoutMs != null ? connectionTimeoutMs : 60000;
    }

    protected final void setBody(String body) {
        this.setOutputParameter(BODY_AS_STRING_OUTPUT_PARAMETER, body);
    }

    protected final void setBody(Object body) {
        this.setOutputParameter(BODY_AS_OBJECT_OUTPUT_PARAMETER, body);
    }

    protected final void setHeaders(Map<String, String> headers) {
        this.setOutputParameter(HEADERS_OUTPUT_PARAMETER, headers);
    }

    protected final void setStatusCode(Integer statusCode) {
        this.setOutputParameter(STATUS_CODE_OUTPUT_PARAMETER, statusCode);
    }

    protected final void setStatusMessage(String statusMessage) {
        this.setOutputParameter(STATUS_MESSAGE_OUTPUT_PARAMETER, statusMessage);
    }

    public void validateInputParameters() throws ConnectorValidationException {
        try {
            this.getUrl();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("url type is invalid");
        }
        try {
            this.getMethod();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("method type is invalid");
        }
        try {
            this.getContentType();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("contentType type is invalid");
        }
        try {
            this.getCharset();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("charset type is invalid");
        }
        try {
            this.getUrlCookies();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("urlCookies type is invalid");
        }
        try {
            this.getUrlHeaders();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("urlHeaders type is invalid");
        }
        try {
            this.getBody();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("body type is invalid");
        }
        try {
            this.getDoNotFollowRedirect();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("do_not_follow_redirect type is invalid");
        }
        try {
            this.getIgnoreBody();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("ignore_body type is invalid");
        }
        try {
            this.getTLS();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("TLS type is invalid");
        }
        this.validateTrustCertificateStrategyInput();
        this.validateHostnameVerifierInput();
        try {
            this.getTrustStoreFile();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("trust_store_file type is invalid");
        }
        try {
            this.getTrustStorePassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("trust_store_password type is invalid");
        }
        try {
            this.getKeyStoreFile();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("key_store_file type is invalid");
        }
        try {
            this.getKeyStorePassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("key_store_password type is invalid");
        }
        try {
            this.getAuthUsername();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_username type is invalid");
        }
        try {
            this.getAuthPassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_password type is invalid");
        }
        try {
            this.getAuthHost();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_host type is invalid");
        }
        try {
            this.getAuthPort();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_port type is invalid");
        }
        try {
            this.getAuthRealm();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_realm type is invalid");
        }
        try {
            this.getAuthPreemptive();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_preemptive type is invalid");
        }
        try {
            this.getProxyProtocol();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_protocol type is invalid");
        }
        try {
            this.getProxyHost();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_host type is invalid");
        }
        try {
            this.getProxyPort();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_port type is invalid");
        }
        try {
            this.getProxyUsername();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_username type is invalid");
        }
        try {
            this.getProxyPassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_password type is invalid");
        }
        try {
            this.getSocketTimeoutMs();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("socket_timeout_ms type is invalid");
        }
        try {
            this.getConnectionTimeoutMs();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("connection_timeout_ms type is invalid");
        }
    }

    private void validateTrustCertificateStrategyInput() throws ConnectorValidationException {
        String trustParam = null;
        try {
            trustParam = (String)this.getInputParameter(TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER);
            if (trustParam != null && !trustParam.trim().isEmpty()) {
                TrustCertificateStrategy.valueOf(trustParam);
            }
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException(String.format("%s type is invalid", TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER));
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorValidationException(String.format("'%s' option is invalid for %s. Only one of %s is supported.", trustParam, TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER, Arrays.toString((Object[])TrustCertificateStrategy.values())));
        }
    }

    private void validateHostnameVerifierInput() throws ConnectorValidationException {
        String hostNameVerifierParam = null;
        try {
            hostNameVerifierParam = (String)this.getInputParameter(HOSTNAME_VERIFIER_INPUT_PARAMETER);
            if (hostNameVerifierParam != null && !hostNameVerifierParam.trim().isEmpty()) {
                SSLVerifier.getSSLVerifierFromValue(hostNameVerifierParam.toUpperCase());
            }
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException(String.format("%s type is invalid", HOSTNAME_VERIFIER_INPUT_PARAMETER));
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorValidationException(String.format("'%s' option is invalid for %s. Only one of %s is supported.", hostNameVerifierParam, HOSTNAME_VERIFIER_INPUT_PARAMETER, Arrays.toString((Object[])SSLVerifier.values())));
        }
    }
}

