/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.bonitasoft.connectors.rest.AbstractRESTConnectorImpl;
import org.bonitasoft.connectors.rest.model.Authorization;
import org.bonitasoft.connectors.rest.model.AuthorizationType;
import org.bonitasoft.connectors.rest.model.BasicDigestAuthorization;
import org.bonitasoft.connectors.rest.model.HTTPMethod;
import org.bonitasoft.connectors.rest.model.Proxy;
import org.bonitasoft.connectors.rest.model.ProxyProtocol;
import org.bonitasoft.connectors.rest.model.Request;
import org.bonitasoft.connectors.rest.model.SSL;
import org.bonitasoft.connectors.rest.model.SSLVerifier;
import org.bonitasoft.connectors.rest.model.Store;
import org.bonitasoft.connectors.rest.model.TrustCertificateStrategy;
import org.bonitasoft.connectors.rest.utils.HttpStatusFailureException;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SRetryableException;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class RESTConnector
extends AbstractRESTConnectorImpl {
    private static final String HTTP_PROTOCOL = "HTTP";
    private static final int HTTP_PROTOCOL_VERSION_MAJOR = 1;
    private static final int HTTP_PROTOCOL_VERSION_MINOR = 1;
    private static final List<String> SECRET_HEADER_NAMES = List.of("authorization", "token", "set-cookie");
    private static final Logger LOGGER = Logger.getLogger(RESTConnector.class.getName());
    static final String DEFAULT_JVM_CHARSET_FALLBACK_PROPERTY = "org.bonitasoft.connectors.rest.response.fallbackToJVMCharset";
    private final boolean hasBody;

    protected RESTConnector(boolean hasBody) {
        this.hasBody = hasBody;
    }

    @Override
    public void validateInputParameters() throws ConnectorValidationException {
        super.validateInputParameters();
        LOGGER.fine("super validateInputParameters done.");
        ArrayList<String> messages = new ArrayList<String>(0);
        if (!this.isStringInputValid(this.getUrl())) {
            messages.add("url");
        } else {
            try {
                new URL(this.getUrl());
            }
            catch (MalformedURLException e) {
                messages.add("url");
            }
        }
        if (!this.isStringInputValid(this.getMethod())) {
            messages.add("method");
        }
        if (Objects.equals(this.getMethod(), HTTPMethod.POST.name()) || Objects.equals(this.getMethod(), HTTPMethod.PUT.name()) || Objects.equals(this.getMethod(), HTTPMethod.PATCH.name())) {
            if (!this.isStringInputValid(this.getContentType())) {
                messages.add("contentType");
            }
            if (!this.isStringInputValid(this.getCharset())) {
                messages.add("charset");
            }
            String body = this.getBody();
            String documentBody = this.getDocumentBody();
            if (body != null && !body.trim().isEmpty() && documentBody != null && !documentBody.trim().isEmpty()) {
                messages.add("Either body input or documentBody input should be set. Found both.");
            }
        }
        List<List<?>> urlCookies = this.getUrlCookies();
        messages.addAll(this.manageKeyValueCouples(urlCookies, "urlCookies"));
        List<List<?>> urlheaders = this.getUrlHeaders();
        messages.addAll(this.manageKeyValueCouples(urlheaders, "urlHeaders"));
        if (!messages.isEmpty()) {
            LOGGER.fine(() -> String.format("validateInputParameters error: %s", messages.toString()));
            throw new ConnectorValidationException((Connector)this, messages);
        }
    }

    private boolean isStringInputValid(String value) {
        return value != null && !value.isEmpty();
    }

    private List<String> manageKeyValueCouples(List<?> keyValueCouples, String inputName) {
        ArrayList<String> messages = new ArrayList<String>();
        if (keyValueCouples == null) {
            return messages;
        }
        for (Object keyValueCouple : keyValueCouples) {
            if (keyValueCouple instanceof List) {
                List keyValueCoupleRow = (List)keyValueCouple;
                if (!this.isItAKeyValueCouple(keyValueCoupleRow)) {
                    messages.add(inputName + " - columns - " + keyValueCoupleRow.size());
                    continue;
                }
                if (this.isKeyValueCoupleValid(keyValueCoupleRow)) continue;
                messages.add(inputName + " - value");
                continue;
            }
            messages.add(inputName + " - type");
        }
        return messages;
    }

    private boolean isKeyValueCoupleValid(List<?> keyValueCoupleRow) {
        return keyValueCoupleRow.get(0) != null && !keyValueCoupleRow.get(0).toString().isEmpty() && keyValueCoupleRow.get(1) != null;
    }

    private boolean isItAKeyValueCouple(List<?> keyValueCoupleRow) {
        return keyValueCoupleRow.size() == 2;
    }

    protected void executeBusinessLogic() throws ConnectorException {
        try {
            Request request = this.buildRequest();
            this.execute(request);
        }
        catch (SRetryableException e) {
            throw e;
        }
        catch (Exception e) {
            this.logException(e);
            throw new ConnectorException((Throwable)e);
        }
    }

    private Request buildRequest() throws MalformedURLException, ConnectorException {
        Request request = new Request();
        request.setUrl(new URL(this.getUrl()));
        LOGGER.fine(() -> "URL set to: " + request.getUrl().toString());
        request.setRestMethod(HTTPMethod.getRESTHTTPMethodFromValue(this.getMethod()));
        LOGGER.fine(() -> "Method set to: " + request.getRestMethod().toString());
        if (request.getRestMethod() == HTTPMethod.POST || request.getRestMethod() == HTTPMethod.PUT || request.getRestMethod() == HTTPMethod.PATCH) {
            ContentType contentType = ContentType.create((String)this.getContentType(), (Charset)Charset.forName(this.getCharset()));
            request.setContentType(contentType);
            LOGGER.fine(() -> "Content-Type set to: " + contentType.toString());
        }
        this.setBody(request);
        request.setRedirect(this.getDoNotFollowRedirect() == false);
        LOGGER.fine(() -> "Follow redirect set to: " + request.isRedirect());
        request.setIgnore(this.getIgnoreBody());
        LOGGER.fine(() -> "Ignore body set to: " + request.isIgnore());
        for (List<?> urlheaderRow : this.getUrlHeaders()) {
            String name = urlheaderRow.get(0).toString();
            String value = urlheaderRow.get(1).toString();
            request.addHeader(name, value);
            LOGGER.fine(() -> "Add header: " + urlheaderRow.get(0).toString() + " set as " + urlheaderRow.get(1).toString());
        }
        if (this.getAddBonitaContextHeaders().booleanValue()) {
            LOGGER.fine("Adding Bonita context headers.");
            this.addBonitaContextHeader(request, this.getBonitaActivityInstanceIdHeader(), Long.toString(this.getExecutionContext().getActivityInstanceId()));
            this.addBonitaContextHeader(request, this.getBonitaProcessInstanceIdHeader(), Long.toString(this.getExecutionContext().getProcessInstanceId()));
            this.addBonitaContextHeader(request, this.getBonitaRootProcessInstanceIdHeader(), Long.toString(this.getExecutionContext().getRootProcessInstanceId()));
            this.addBonitaContextHeader(request, this.getBonitaProcessDefinitionIdHeader(), Long.toString(this.getExecutionContext().getProcessDefinitionId()));
            this.addBonitaContextHeader(request, this.getBonitaTaskAssigneeIdHeader(), Long.toString(this.getExecutionContext().getTaskAssigneeId()));
            LOGGER.fine("Context headers added.");
        }
        for (List<?> urlCookieRow : this.getUrlCookies()) {
            request.addCookie(urlCookieRow.get(0).toString(), urlCookieRow.get(1).toString());
            LOGGER.fine(() -> "Add cookie: " + urlCookieRow.get(0).toString() + " with content " + urlCookieRow.get(1).toString());
        }
        request.setSsl(this.buildSSL());
        LOGGER.fine("Add the SSL options");
        if (this.isProxySet()) {
            request.setProxy(this.buildProxy());
            LOGGER.fine("Add the Proxy options");
        }
        if (this.getAuthType() == AuthorizationType.BASIC) {
            LOGGER.fine("Add basic auth");
            request.setAuthorization(this.buildBasicAuthorization());
        } else if (this.getAuthType() == AuthorizationType.DIGEST) {
            LOGGER.fine("Add digest auth");
            request.setAuthorization(this.buildDigestAuthorization());
        }
        return request;
    }

    private void addBonitaContextHeader(Request request, String headerName, String headerValue) {
        if (StringUtils.isNotBlank((CharSequence)headerName) && StringUtils.isNotBlank((CharSequence)headerValue)) {
            LOGGER.fine(() -> "Adding header: " + headerName + " with value " + headerValue);
            request.setHeader(headerName, headerValue);
        }
    }

    private void setBody(Request request) throws ConnectorException {
        String body = this.getBody();
        String documentBody = this.getDocumentBody();
        request.setHasBody(this.hasBody());
        if (StringUtils.isNotBlank((CharSequence)body)) {
            request.setBody((Serializable)((Object)body));
            LOGGER.fine(() -> "Body set to: " + this.abbreviateBody(request.getBody().toString()));
        } else if (documentBody != null && !documentBody.trim().isEmpty()) {
            try {
                ProcessAPI processAPI = this.getAPIAccessor().getProcessAPI();
                Document doc = processAPI.getLastDocument(this.getExecutionContext().getProcessInstanceId(), documentBody);
                request.setBody((Serializable)processAPI.getDocumentContent(doc.getContentStorageId()));
                LOGGER.fine(() -> String.format("Body set with %s document content", documentBody));
            }
            catch (DocumentNotFoundException e) {
                throw new ConnectorException(String.format("Document '%s' not found", documentBody), (Throwable)e);
            }
        } else {
            request.setBody((Serializable)((Object)""));
        }
    }

    private boolean isProxySet() {
        return this.isStringInputValid(this.getProxyHost()) && this.isStringInputValid(this.getProxyProtocol());
    }

    BasicDigestAuthorization buildDigestAuthorization() {
        BasicDigestAuthorization authorization = new BasicDigestAuthorization(false);
        authorization.setUsername(this.getAuthUsername());
        authorization.setPassword(this.getAuthPassword());
        if (this.isStringInputValid(this.getAuthHost())) {
            authorization.setHost(this.getAuthHost());
        }
        authorization.setPort(this.getAuthPort());
        if (this.isStringInputValid(this.getAuthRealm())) {
            authorization.setRealm(this.getAuthRealm());
        }
        authorization.setPreemptive(this.getAuthPreemptive());
        return authorization;
    }

    BasicDigestAuthorization buildBasicAuthorization() {
        BasicDigestAuthorization authorization = new BasicDigestAuthorization(true);
        authorization.setUsername(this.getAuthUsername());
        authorization.setPassword(this.getAuthPassword());
        if (this.isStringInputValid(this.getAuthHost())) {
            authorization.setHost(this.getAuthHost());
        }
        authorization.setPort(this.getAuthPort());
        if (this.isStringInputValid(this.getAuthRealm())) {
            authorization.setRealm(this.getAuthRealm());
        }
        authorization.setPreemptive(this.getAuthPreemptive());
        return authorization;
    }

    SSL buildSSL() {
        SSL ssl = new SSL();
        ssl.setSslVerifier(this.getHostnameVerifier());
        ssl.setTrustCertificateStrategy(this.getTrustCertificateStrategy());
        ssl.setUseTLS(this.getTLS());
        if (this.isStringInputValid(this.getTrustStoreFile()) && this.isStringInputValid(this.getTrustStorePassword())) {
            Store trustStore = new Store();
            trustStore.setFile(new File(this.getTrustStoreFile()));
            trustStore.setPassword(this.getTrustStorePassword());
            ssl.setTrustStore(trustStore);
        }
        if (this.isStringInputValid(this.getKeyStoreFile()) && this.isStringInputValid(this.getKeyStorePassword())) {
            Store keyStore = new Store();
            keyStore.setFile(new File(this.getKeyStoreFile()));
            keyStore.setPassword(this.getKeyStorePassword());
            ssl.setKeyStore(keyStore);
        }
        return ssl;
    }

    Proxy buildProxy() {
        Proxy proxy = new Proxy();
        proxy.setProtocol(ProxyProtocol.valueOf(this.getProxyProtocol().toUpperCase()));
        proxy.setHost(this.getProxyHost());
        proxy.setPort(this.getProxyPort());
        if (this.isStringInputValid(this.getProxyUsername())) {
            proxy.setUsername(this.getProxyUsername());
        }
        if (this.isStringInputValid(this.getProxyPassword())) {
            proxy.setPassword(this.getProxyPassword());
        }
        return proxy;
    }

    private void setOutputs(HttpResponse response, Request request) throws IOException {
        if (response != null) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (request.isIgnore()) {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                } else {
                    this.parseResponse(entity);
                }
            } else {
                this.setBody("");
                this.setBody(Collections.emptyMap());
            }
            this.setHeaders(this.asMap(response.getAllHeaders()));
            this.setStatusCode(response.getStatusLine().getStatusCode());
            this.setStatusMessage(response.getStatusLine().getReasonPhrase());
            LOGGER.fine("All outputs have been set.");
        } else {
            LOGGER.fine("Response is null.");
        }
    }

    private String abbreviateBody(String body) {
        Integer maximumBodyContentPrintedLogs = this.getMaximumBodyContentPrintedLogs();
        if (maximumBodyContentPrintedLogs == 0) {
            return "Hidden body content";
        }
        String abbrevMarker = "...";
        return StringUtils.abbreviate((String)body, (String)"...", (int)(this.getMaximumBodyContentPrintedLogs() + "...".length()));
    }

    private void parseResponse(HttpEntity entity) throws IOException {
        block6: {
            boolean fallbackToDefaultCharset = Boolean.parseBoolean(System.getProperty(DEFAULT_JVM_CHARSET_FALLBACK_PROPERTY));
            String stringContent = EntityUtils.toString((HttpEntity)entity, (Charset)(fallbackToDefaultCharset ? Charset.defaultCharset() : null));
            String bodyResponse = stringContent != null ? stringContent.trim() : "";
            LOGGER.fine(() -> "Response body: " + this.abbreviateBody(bodyResponse));
            this.setBody(bodyResponse);
            this.setBody(Collections.emptyMap());
            ContentType contentType = ContentType.get((HttpEntity)entity);
            if (contentType != null && ContentType.APPLICATION_JSON.getMimeType().equals(contentType.getMimeType())) {
                try {
                    if (bodyResponse.startsWith("[")) {
                        this.setBody(new ObjectMapper().readValue(bodyResponse, List.class));
                        break block6;
                    }
                    if (bodyResponse.startsWith("{")) {
                        this.setBody(new ObjectMapper().readValue(bodyResponse, HashMap.class));
                        break block6;
                    }
                    this.setBody(new ObjectMapper().readValue(bodyResponse, Object.class));
                }
                catch (JsonParseException | JsonMappingException e) {
                    LOGGER.warning(String.format("BodyAsObject output cannot be set. Response content is not valid json(%s).", bodyResponse));
                }
            } else {
                LOGGER.warning(() -> String.format("Body as map output cannot be set. Response content type is not json compliant(%s).", contentType != null ? contentType : "no Content-Type in response header"));
            }
        }
    }

    private Map<String, String> asMap(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers != null) {
            for (Header header : headers) {
                String name = header.getName();
                if (StringUtils.isEmpty((CharSequence)header.getValue())) continue;
                if (!result.containsKey(name)) {
                    result.put(name, header.getValue());
                    continue;
                }
                String currentValue = (String)result.get(name);
                result.put(name, currentValue + "," + header.getValue());
            }
        }
        return result;
    }

    HttpClientBuilder newHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Request request, Consumer<HttpResponse> consumer, Consumer<HttpResponse> retryConsumer, Consumer<HttpResponse> failureConsumer) throws Exception {
        CloseableHttpClient httpClient = null;
        try {
            Serializable body;
            URL url = request.getUrl();
            String urlHost = url.getHost();
            RequestConfig.Builder requestConfigurationBuilder = RequestConfig.custom();
            requestConfigurationBuilder.setConnectionRequestTimeout(this.getConnectionTimeoutMs().intValue());
            requestConfigurationBuilder.setRedirectsEnabled(request.isRedirect());
            requestConfigurationBuilder.setConnectTimeout(this.getConnectionTimeoutMs().intValue());
            requestConfigurationBuilder.setSocketTimeout(this.getSocketTimeoutMs().intValue());
            HttpClientBuilder httpClientBuilder = this.newHttpClientBuilder();
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
            this.setSSL(request.getSsl(), httpClientBuilder);
            this.setProxy(request.getProxy(), httpClientBuilder, requestConfigurationBuilder);
            this.setCookies(requestConfigurationBuilder, httpClientBuilder, request.getCookies(), urlHost);
            RequestBuilder requestBuilder = this.getRequestBuilderFromMethod(request.getRestMethod());
            requestBuilder.setVersion(new ProtocolVersion(HTTP_PROTOCOL, 1, 1));
            int urlPort = url.getPort();
            if (url.getPort() == -1) {
                urlPort = url.getDefaultPort();
            }
            String urlProtocol = url.getProtocol();
            String urlStr = url.toString();
            requestBuilder.setUri(urlStr);
            this.setHeaders(requestBuilder, request.getHeaders());
            if (request.hasBody() && (body = request.getBody()) != null) {
                requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(this.toByteArray(body, request.getContentType().getCharset()), request.getContentType()));
            }
            HttpContext httpContext = this.setAuthorizations(requestConfigurationBuilder, request.getAuthorization(), request.getProxy(), urlHost, urlPort, urlProtocol, httpClientBuilder);
            LOGGER.info(() -> String.valueOf((Object)request.getRestMethod()) + " " + String.valueOf(url));
            requestBuilder.setConfig(requestConfigurationBuilder.build());
            httpClientBuilder.setDefaultRequestConfig(requestConfigurationBuilder.build());
            HttpUriRequest httpRequest = requestBuilder.build();
            this.logHeaders(httpRequest);
            httpClient = httpClientBuilder.build();
            LOGGER.fine("Request sent.");
            CloseableHttpResponse httpResponse = httpClient.execute(httpRequest, httpContext);
            LOGGER.fine("Response received.");
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            LOGGER.fine(() -> String.format("%s response status is: %s - %s", request, statusCode, httpResponse.getStatusLine().getReasonPhrase()));
            this.logHeaders(httpResponse);
            if (retryConsumer != null && this.retryRequested((HttpResponse)httpResponse)) {
                LOGGER.fine("Retry requested.");
                retryConsumer.accept((HttpResponse)httpResponse);
            } else if (failureConsumer != null && this.failureRequested((HttpResponse)httpResponse)) {
                LOGGER.fine("Failure requested.");
                failureConsumer.accept((HttpResponse)httpResponse);
            } else {
                consumer.accept((HttpResponse)httpResponse);
            }
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException ex) {
                this.logException(ex);
            }
        }
    }

    private void logHeaders(HttpUriRequest httpRequest) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        LOGGER.fine("Request headers:");
        for (Header header : httpRequest.getAllHeaders()) {
            this.logHeader(header);
        }
    }

    private void logHeaders(CloseableHttpResponse httpResponse) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        LOGGER.fine("Response headers:");
        for (Header header : httpResponse.getAllHeaders()) {
            this.logHeader(header);
        }
    }

    private void logHeader(Header header) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        String lowerCaseName = header.getName().toLowerCase();
        String value = SECRET_HEADER_NAMES.stream().anyMatch(lowerCaseName::contains) && this.getShowSensitiveHeadersInLogs() == false ? "Hidden header value" : header.getValue();
        LOGGER.fine(header.getName() + ": " + value);
    }

    private boolean failureRequested(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (this.getFailExceptionHttpCodes().contains(Integer.toString(statusCode))) {
            return false;
        }
        if (this.getFailOnHttp5xx().booleanValue() && statusCode >= 500 && statusCode <= 599) {
            return true;
        }
        return this.getFailOnHttp4xx() != false && statusCode >= 400 && statusCode <= 499;
    }

    private boolean retryRequested(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (this.getRetryAdditionalHttpCodes().contains(Integer.toString(statusCode))) {
            return true;
        }
        return this.getRetryOnHttp5xx() != false && statusCode >= 500 && statusCode <= 599;
    }

    protected void execute(Request request) throws Exception {
        this.execute(request, response -> {
            try {
                this.setOutputs((HttpResponse)response, request);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, response -> {
            throw new SRetryableException((Exception)new HttpStatusFailureException(response.getStatusLine().getStatusCode()));
        }, response -> {
            throw new HttpStatusFailureException(response.getStatusLine().getStatusCode());
        });
    }

    private byte[] toByteArray(Serializable body, Charset charset) {
        if (body instanceof String) {
            return ((String)((Object)body)).getBytes(charset);
        }
        if (body instanceof byte[]) {
            return (byte[])body;
        }
        throw new IllegalArgumentException("Body content type not supported. Expected String or byte[]");
    }

    private void setSSL(SSL ssl, HttpClientBuilder httpClientBuilder) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (ssl != null) {
            KeyStore keyStore;
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            TrustCertificateStrategy trustCertificateStrategy = ssl.getTrustCertificateStrategy();
            if (trustCertificateStrategy == TrustCertificateStrategy.TRUST_SELF_SIGNED) {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)TrustSelfSignedStrategy.INSTANCE);
            } else if (trustCertificateStrategy == TrustCertificateStrategy.TRUST_ALL) {
                sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> Boolean.TRUE);
            }
            if (ssl.getTrustStore() != null) {
                keyStore = ssl.getTrustStore().generateKeyStore();
                if (trustCertificateStrategy == TrustCertificateStrategy.DEFAULT) {
                    sslContextBuilder.loadTrustMaterial(keyStore, null);
                }
            }
            if (ssl.getKeyStore() != null) {
                keyStore = ssl.getKeyStore().generateKeyStore();
                String keyStorePassword = ssl.getKeyStore().getPassword();
                sslContextBuilder.loadKeyMaterial(keyStore, keyStorePassword.toCharArray());
            }
            sslContextBuilder.setSecureRandom(null);
            sslContextBuilder.setProtocol(ssl.isUseTLS() ? "TLS" : "SSL");
            SSLVerifier verifier = ssl.getSslVerifier();
            HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            switch (verifier) {
                case ALLOW: {
                    hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                    break;
                }
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), hostnameVerifier);
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        }
    }

    private void setProxy(Proxy proxy, HttpClientBuilder httpClientBuilder, RequestConfig.Builder requestConfigurationBuilder) {
        if (proxy != null) {
            HttpHost httpHost = new HttpHost(proxy.getHost(), proxy.getPort().intValue());
            httpClientBuilder.setProxy(httpHost);
            httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
            requestConfigurationBuilder.setProxy(httpHost);
            ArrayList<String> authPrefs = new ArrayList<String>();
            authPrefs.add("Basic");
            requestConfigurationBuilder.setProxyPreferredAuthSchemes(authPrefs);
        }
    }

    private void setProxyCrendentials(Proxy proxy, CredentialsProvider credentialsProvider) {
        if (proxy != null && proxy.hasCredentials()) {
            credentialsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort().intValue()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword() == null ? "" : proxy.getPassword()));
        }
    }

    private void setCookies(RequestConfig.Builder requestConfigurationBuilder, HttpClientBuilder httpClientBuilder, List<HttpCookie> cookies, String urlHost) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        for (HttpCookie cookie : cookies) {
            BasicClientCookie c = new BasicClientCookie(cookie.getName(), cookie.getValue());
            c.setPath("/");
            c.setVersion(0);
            c.setDomain(urlHost);
            cookieStore.addCookie((Cookie)c);
        }
        httpClientBuilder.setDefaultCookieStore((CookieStore)cookieStore);
        requestConfigurationBuilder.setCookieSpec("default");
    }

    private void setHeaders(RequestBuilder requestBuilder, List<Header> headerData) {
        for (Header aHeaderData : headerData) {
            requestBuilder.addHeader(aHeaderData);
        }
    }

    private HttpContext setAuthorizations(RequestConfig.Builder requestConfigurationBuilder, Authorization authorization, Proxy proxy, String urlHost, int urlPort, String urlProtocol, HttpClientBuilder httpClientBuilder) {
        HttpClientContext httpContext = HttpClientContext.create();
        if (authorization != null) {
            if (authorization instanceof BasicDigestAuthorization) {
                BasicDigestAuthorization castAuthorization = (BasicDigestAuthorization)authorization;
                ArrayList<String> authPrefs = new ArrayList<String>();
                authPrefs.add(castAuthorization.isBasic() ? "Basic" : "Digest");
                requestConfigurationBuilder.setTargetPreferredAuthSchemes(authPrefs);
                String username = castAuthorization.getUsername();
                String password = castAuthorization.getPassword();
                String host = urlHost;
                if (this.isStringInputValid(castAuthorization.getHost())) {
                    host = castAuthorization.getHost();
                }
                int port = urlPort;
                if (castAuthorization.getPort() != null) {
                    port = castAuthorization.getPort();
                }
                String realm = AuthScope.ANY_REALM;
                if (this.isStringInputValid(castAuthorization.getRealm())) {
                    realm = castAuthorization.getRealm();
                }
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(host, port, realm), (Credentials)new UsernamePasswordCredentials(username, password));
                this.setProxyCrendentials(proxy, (CredentialsProvider)credentialsProvider);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                if (castAuthorization.isPreemptive() || proxy != null) {
                    BasicAuthCache authenticationCache = new BasicAuthCache();
                    if (castAuthorization.isPreemptive()) {
                        BasicScheme authorizationScheme = castAuthorization.isBasic() ? new BasicScheme() : new DigestScheme();
                        authenticationCache.put(new HttpHost(host, port, urlProtocol), (AuthScheme)authorizationScheme);
                    }
                    if (proxy != null) {
                        BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
                        authenticationCache.put(new HttpHost(proxy.getHost(), proxy.getPort().intValue()), (AuthScheme)basicScheme);
                    }
                    HttpClientContext localContext = HttpClientContext.create();
                    localContext.setAuthCache((AuthCache)authenticationCache);
                    httpContext = localContext;
                }
            }
        } else if (proxy != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            this.setProxyCrendentials(proxy, (CredentialsProvider)credentialsProvider);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            if (proxy.hasCredentials()) {
                BasicAuthCache authoriationCache = new BasicAuthCache();
                BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
                authoriationCache.put(new HttpHost(proxy.getHost(), proxy.getPort().intValue()), (AuthScheme)basicScheme);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache((AuthCache)authoriationCache);
                httpContext = localContext;
            }
        }
        return httpContext;
    }

    private RequestBuilder getRequestBuilderFromMethod(HTTPMethod method) {
        switch (method) {
            case GET: {
                return RequestBuilder.get();
            }
            case POST: {
                return RequestBuilder.post();
            }
            case PUT: {
                return RequestBuilder.put();
            }
            case DELETE: {
                return RequestBuilder.delete();
            }
            case HEAD: {
                return RequestBuilder.head();
            }
            case PATCH: {
                return RequestBuilder.patch();
            }
        }
        throw new IllegalStateException("Impossible to get the RequestBuilder from the \"" + method.name() + "\" name.");
    }

    private void logException(Exception e) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(e.toString());
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            stringBuilder.append("\n").append(stackTraceElement);
        }
        LOGGER.fine(() -> "executeBusinessLogic error: " + stringBuilder.toString());
    }

    @Override
    public boolean hasBody() {
        return this.hasBody;
    }
}

