/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.connectors.rest.model.AuthorizationType;
import org.bonitasoft.connectors.rest.model.ProxyProtocol;
import org.bonitasoft.connectors.rest.model.SSLVerifier;
import org.bonitasoft.connectors.rest.model.TrustCertificateStrategy;
import org.bonitasoft.connectors.rest.utils.ProxyUtils;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public abstract class AbstractRESTConnectorImpl
extends AbstractConnector {
    protected static final String URL_INPUT_PARAMETER = "url";
    protected static final String METHOD_INPUT_PARAMETER = "method";
    protected static final String CONTENTTYPE_INPUT_PARAMETER = "contentType";
    protected static final String CHARSET_INPUT_PARAMETER = "charset";
    protected static final String URLCOOKIES_INPUT_PARAMETER = "urlCookies";
    protected static final String URLHEADERS_INPUT_PARAMETER = "urlHeaders";
    protected static final String ADD_BONITA_CONTEXT_HEADERS_INPUT_PARAMETER = "add_bonita_context_headers";
    protected static final String BONITA_ACTIVITY_INSTANCE_ID_HEADER_INPUT_PARAMETER = "bonita_activity_instance_id_header";
    protected static final String BONITA_PROCESS_INSTANCE_ID_HEADER_INPUT_PARAMETER = "bonita_process_instance_id_header";
    protected static final String BONITA_ROOT_PROCESS_INSTANCE_ID_HEADER_INPUT_PARAMETER = "bonita_root_process_instance_id_header";
    protected static final String BONITA_PROCESS_DEFINITION_ID_HEADER_INPUT_PARAMETER = "bonita_process_definition_id_header";
    protected static final String BONITA_TASK_ASSIGNEE_ID_HEADER_INPUT_PARAMETER = "bonita_task_assignee_id_header";
    protected static final String DOCUMENT_BODY_INPUT_PARAMETER = "documentBody";
    protected static final String BODY_INPUT_PARAMETER = "body";
    protected static final String DO_NOT_FOLLOW_REDIRECT_INPUT_PARAMETER = "do_not_follow_redirect";
    protected static final String IGNORE_BODY_INPUT_PARAMETER = "ignore_body";
    protected static final String FAIL_ON_HTTP_4XX_INPUT_PARAMETER = "fail_on_http_4xx";
    protected static final String FAIL_ON_HTTP_5XX_INPUT_PARAMETER = "fail_on_http_5xx";
    protected static final String FAILURE_EXCEPTIONS_HTTP_CODES_INPUT_PARAMETER = "failure_exception_codes";
    protected static final String RETRY_ON_HTTP_5XX_INPUT_PARAMETER = "retry_on_http_5xx";
    protected static final String RETRY_ADDITIONAL_HTTP_CODES_INPUT_PARAMETER = "retry_additional_codes";
    protected static final String MAXIMUM_BODY_CONTENT_PRINTED_LOGS_PARAMETER = "max_body_content_printed";
    protected static final String SENSITIVE_HEADERS_PRINTED_LOGS_PARAMETER = "sensitive_headers_printed";
    protected static final String TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER = "trust_strategy";
    protected static final String TLS_INPUT_PARAMETER = "TLS";
    protected static final String HOSTNAME_VERIFIER_INPUT_PARAMETER = "hostname_verifier";
    protected static final String TRUST_STORE_FILE_INPUT_PARAMETER = "trust_store_file";
    protected static final String TRUST_STORE_PASSWORD_INPUT_PARAMETER = "trust_store_password";
    protected static final String KEY_STORE_FILE_INPUT_PARAMETER = "key_store_file";
    protected static final String KEY_STORE_PASSWORD_INPUT_PARAMETER = "key_store_password";
    protected static final String AUTH_TYPE_PARAMETER = "auth_type";
    protected static final String AUTH_USERNAME_INPUT_PARAMETER = "auth_username";
    protected static final String AUTH_PASSWORD_INPUT_PARAMETER = "auth_password";
    protected static final String AUTH_HOST_INPUT_PARAMETER = "auth_host";
    protected static final String AUTH_PORT_INPUT_PARAMETER = "auth_port";
    protected static final String AUTH_REALM_INPUT_PARAMETER = "auth_realm";
    protected static final String AUTH_PREEMPTIVE_INPUT_PARAMETER = "auth_preemptive";
    protected static final String PROXY_PROTOCOL_INPUT_PARAMETER = "proxy_protocol";
    protected static final String PROXY_HOST_INPUT_PARAMETER = "proxy_host";
    protected static final String PROXY_PORT_INPUT_PARAMETER = "proxy_port";
    protected static final String PROXY_USERNAME_INPUT_PARAMETER = "proxy_username";
    protected static final String PROXY_PASSWORD_INPUT_PARAMETER = "proxy_password";
    protected static final String BODY_AS_STRING_OUTPUT_PARAMETER = "bodyAsString";
    protected static final String BODY_AS_OBJECT_OUTPUT_PARAMETER = "bodyAsObject";
    protected static final String HEADERS_OUTPUT_PARAMETER = "headers";
    protected static final String STATUS_CODE_OUTPUT_PARAMETER = "status_code";
    protected static final String STATUS_MESSAGE_OUTPUT_PARAMETER = "status_message";
    protected static final String SOCKET_TIMEOUT_MS_PARAMETER = "socket_timeout_ms";
    protected static final String CONNECTION_TIMEOUT_MS_PARAMETER = "connection_timeout_ms";
    protected static final String AUTOMATIC_PROXY_RESOLUTION_PARAMETER = "automatic_proxy_resolution";
    protected static final int SOCKET_TIMEOUT_MS_DEFAULT_VALUE = 60000;
    protected static final int CONNECTION_TIMEOUT_MS_DEFAULT_VALUE = 60000;

    protected final String getUrl() {
        return (String)this.getInputParameter(URL_INPUT_PARAMETER);
    }

    protected String getMethod() {
        return (String)this.getInputParameter(METHOD_INPUT_PARAMETER);
    }

    protected final String getContentType() {
        return (String)this.getInputParameter(CONTENTTYPE_INPUT_PARAMETER);
    }

    protected final String getCharset() {
        return (String)this.getInputParameter(CHARSET_INPUT_PARAMETER);
    }

    protected final List<List<?>> getUrlCookies() {
        List<List<?>> cookies = (List<List<?>>)this.getInputParameter(URLCOOKIES_INPUT_PARAMETER);
        if (cookies == null) {
            cookies = Collections.emptyList();
        }
        cookies.removeIf(this.emptyLines());
        return cookies;
    }

    private Predicate<Object> emptyLines() {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                if (input instanceof List) {
                    List line = (List)input;
                    return line.size() != 2 || this.emptyCell(line, 0) && this.emptyCell(line, 1);
                }
                return true;
            }

            private boolean emptyCell(List<?> line, int cellIndex) {
                Object cellValue = line.get(cellIndex);
                return cellValue == null || cellValue.toString().trim().isEmpty();
            }
        };
    }

    protected final List<List<?>> getUrlHeaders() {
        List<List<?>> headers = (List<List<?>>)this.getInputParameter(URLHEADERS_INPUT_PARAMETER);
        if (headers == null) {
            headers = Collections.emptyList();
        }
        headers.removeIf(this.emptyLines());
        return headers;
    }

    protected final Boolean getAddBonitaContextHeaders() {
        return (Boolean)this.getInputParameter(ADD_BONITA_CONTEXT_HEADERS_INPUT_PARAMETER, Boolean.FALSE);
    }

    protected final String getBonitaActivityInstanceIdHeader() {
        return (String)this.getInputParameter(BONITA_ACTIVITY_INSTANCE_ID_HEADER_INPUT_PARAMETER);
    }

    protected final String getBonitaProcessInstanceIdHeader() {
        return (String)this.getInputParameter(BONITA_PROCESS_INSTANCE_ID_HEADER_INPUT_PARAMETER);
    }

    protected final String getBonitaRootProcessInstanceIdHeader() {
        return (String)this.getInputParameter(BONITA_ROOT_PROCESS_INSTANCE_ID_HEADER_INPUT_PARAMETER);
    }

    protected final String getBonitaProcessDefinitionIdHeader() {
        return (String)this.getInputParameter(BONITA_PROCESS_DEFINITION_ID_HEADER_INPUT_PARAMETER);
    }

    protected final String getBonitaTaskAssigneeIdHeader() {
        return (String)this.getInputParameter(BONITA_TASK_ASSIGNEE_ID_HEADER_INPUT_PARAMETER);
    }

    protected final String getDocumentBody() {
        return (String)this.getInputParameter(DOCUMENT_BODY_INPUT_PARAMETER);
    }

    protected final String getBody() {
        return (String)this.getInputParameter(BODY_INPUT_PARAMETER);
    }

    protected final Boolean getTLS() {
        return (Boolean)this.getInputParameter(TLS_INPUT_PARAMETER, Boolean.TRUE);
    }

    protected final TrustCertificateStrategy getTrustCertificateStrategy() {
        String trustParam = (String)this.getInputParameter(TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER);
        if (trustParam != null && !trustParam.trim().isEmpty()) {
            return TrustCertificateStrategy.valueOf(trustParam);
        }
        return TrustCertificateStrategy.DEFAULT;
    }

    protected final SSLVerifier getHostnameVerifier() {
        return SSLVerifier.getSSLVerifierFromValue((String)this.getInputParameter(HOSTNAME_VERIFIER_INPUT_PARAMETER));
    }

    protected final String getTrustStoreFile() {
        return (String)this.getInputParameter(TRUST_STORE_FILE_INPUT_PARAMETER);
    }

    protected final String getTrustStorePassword() {
        return (String)this.getInputParameter(TRUST_STORE_PASSWORD_INPUT_PARAMETER);
    }

    protected final String getKeyStoreFile() {
        return (String)this.getInputParameter(KEY_STORE_FILE_INPUT_PARAMETER);
    }

    protected final String getKeyStorePassword() {
        return (String)this.getInputParameter(KEY_STORE_PASSWORD_INPUT_PARAMETER);
    }

    protected final Boolean getDoNotFollowRedirect() {
        return (Boolean)this.getInputParameter(DO_NOT_FOLLOW_REDIRECT_INPUT_PARAMETER, Boolean.FALSE);
    }

    protected final Boolean getIgnoreBody() {
        return (Boolean)this.getInputParameter(IGNORE_BODY_INPUT_PARAMETER, Boolean.FALSE);
    }

    protected final Boolean getFailOnHttp5xx() {
        return (Boolean)this.getInputParameter(FAIL_ON_HTTP_5XX_INPUT_PARAMETER, Boolean.FALSE);
    }

    protected final Boolean getFailOnHttp4xx() {
        return (Boolean)this.getInputParameter(FAIL_ON_HTTP_4XX_INPUT_PARAMETER, Boolean.FALSE);
    }

    protected final List<String> getFailExceptionHttpCodes() {
        List exceptionCodes = (List)this.getInputParameter(FAILURE_EXCEPTIONS_HTTP_CODES_INPUT_PARAMETER);
        if (exceptionCodes == null) {
            return Collections.emptyList();
        }
        return exceptionCodes.stream().map(code -> (String)code.get(0)).collect(Collectors.toList());
    }

    protected final Boolean getRetryOnHttp5xx() {
        return (Boolean)this.getInputParameter(RETRY_ON_HTTP_5XX_INPUT_PARAMETER, Boolean.FALSE);
    }

    protected final List<String> getRetryAdditionalHttpCodes() {
        List additionalCodes = (List)this.getInputParameter(RETRY_ADDITIONAL_HTTP_CODES_INPUT_PARAMETER);
        if (additionalCodes == null) {
            return Collections.emptyList();
        }
        return additionalCodes.stream().map(code -> (String)code.get(0)).collect(Collectors.toList());
    }

    protected final Integer getMaximumBodyContentPrintedLogs() {
        return (Integer)this.getInputParameter(MAXIMUM_BODY_CONTENT_PRINTED_LOGS_PARAMETER, Integer.valueOf(1000));
    }

    protected final Boolean getShowSensitiveHeadersInLogs() {
        return (Boolean)this.getInputParameter(SENSITIVE_HEADERS_PRINTED_LOGS_PARAMETER, Boolean.FALSE);
    }

    protected final String getAuthUsername() {
        return (String)this.getInputParameter(AUTH_USERNAME_INPUT_PARAMETER);
    }

    protected final String getAuthPassword() {
        return (String)this.getInputParameter(AUTH_PASSWORD_INPUT_PARAMETER);
    }

    protected final String getAuthHost() {
        return (String)this.getInputParameter(AUTH_HOST_INPUT_PARAMETER);
    }

    protected final Integer getAuthPort() {
        Integer port = (Integer)this.getInputParameter(AUTH_PORT_INPUT_PARAMETER);
        return port == null ? -1 : port;
    }

    protected final String getAuthRealm() {
        return (String)this.getInputParameter(AUTH_REALM_INPUT_PARAMETER);
    }

    protected final Boolean getAuthPreemptive() {
        return (Boolean)this.getInputParameter(AUTH_PREEMPTIVE_INPUT_PARAMETER, Boolean.TRUE);
    }

    protected final AuthorizationType getAuthType() {
        String authType = (String)this.getInputParameter(AUTH_TYPE_PARAMETER);
        return authType != null ? AuthorizationType.valueOf(authType) : AuthorizationType.NONE;
    }

    protected final String getProxyProtocol() {
        if (Boolean.TRUE.equals(this.getAutomaticProxyResolution())) {
            URI url = URI.create(this.getUrl());
            return url.isAbsolute() ? url.getScheme() : ProxyProtocol.HTTP.toString().toLowerCase();
        }
        return (String)this.getInputParameter(PROXY_PROTOCOL_INPUT_PARAMETER);
    }

    protected final String getProxyHost() {
        if (Boolean.TRUE.equals(this.getAutomaticProxyResolution())) {
            return ProxyUtils.hostName(URI.create(this.getUrl())).orElse(null);
        }
        return (String)this.getInputParameter(PROXY_HOST_INPUT_PARAMETER);
    }

    protected final Integer getProxyPort() {
        if (Boolean.TRUE.equals(this.getAutomaticProxyResolution())) {
            return ProxyUtils.port(URI.create(this.getUrl())).orElse(null);
        }
        return (Integer)this.getInputParameter(PROXY_PORT_INPUT_PARAMETER);
    }

    protected final String getProxyUsername() {
        return (String)this.getInputParameter(PROXY_USERNAME_INPUT_PARAMETER);
    }

    protected final String getProxyPassword() {
        return (String)this.getInputParameter(PROXY_PASSWORD_INPUT_PARAMETER);
    }

    protected final Integer getSocketTimeoutMs() {
        return (Integer)this.getInputParameter(SOCKET_TIMEOUT_MS_PARAMETER, Integer.valueOf(60000));
    }

    protected final Integer getConnectionTimeoutMs() {
        return (Integer)this.getInputParameter(CONNECTION_TIMEOUT_MS_PARAMETER, Integer.valueOf(60000));
    }

    protected final Boolean getAutomaticProxyResolution() {
        return (Boolean)this.getInputParameter(AUTOMATIC_PROXY_RESOLUTION_PARAMETER, Boolean.FALSE);
    }

    protected void setBody(String body) {
        this.setOutputParameter(BODY_AS_STRING_OUTPUT_PARAMETER, body);
    }

    protected void setBody(Object body) {
        this.setOutputParameter(BODY_AS_OBJECT_OUTPUT_PARAMETER, body);
    }

    protected void setHeaders(Map<String, String> headers) {
        this.setOutputParameter(HEADERS_OUTPUT_PARAMETER, headers);
    }

    protected void setStatusCode(Integer statusCode) {
        this.setOutputParameter(STATUS_CODE_OUTPUT_PARAMETER, statusCode);
    }

    protected void setStatusMessage(String statusMessage) {
        this.setOutputParameter(STATUS_MESSAGE_OUTPUT_PARAMETER, statusMessage);
    }

    public void validateInputParameters() throws ConnectorValidationException {
        this.validateUrl();
        this.validateMethod();
        this.validateContentType();
        this.validateCharset();
        this.validateUrlCookies();
        this.validateUrlHeaders();
        this.validateAddBonitaContextHeaders();
        this.validateBonitaContextHeaders();
        this.validateBody();
        this.validateIgnoreBody();
        this.validateDoNotFollowRedirect();
        this.validateFailOnHttp5xx();
        this.validateFailOnHttp4xx();
        this.validateFailExceptionHttpCodes();
        this.validateRetryOnHttp5xx();
        this.validateRetryAdditionalHttpCodes();
        this.validateMaximumBodyContentPrintedLogs();
        this.validateShowSensitiveHeadersInLogs();
        this.validateTLS();
        this.validateTrustCertificateStrategyInput();
        this.validateHostnameVerifierInput();
        this.validateTrustStoreFile();
        this.validateTrustStorePassword();
        this.validateKeyStoreFile();
        this.validateKeyStorePassword();
        this.validateAuthUsername();
        this.validateAuthPassword();
        this.validateAuthHost();
        this.validateAuthPort();
        this.validateAuthRealm();
        this.validateAuthPreemptive();
        this.validateProxyProtocol();
        this.validateProxyHost();
        this.validateProxyPort();
        this.validateProxyUsername();
        this.validateProxyPassword();
        this.validateSocketTimeoutMs();
        this.validateConnectionTimeoutMs();
        this.validateAutomaticProxyResolution();
    }

    void validateConnectionTimeoutMs() throws ConnectorValidationException {
        try {
            this.getConnectionTimeoutMs();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("connection_timeout_ms type is invalid");
        }
    }

    void validateSocketTimeoutMs() throws ConnectorValidationException {
        try {
            this.getSocketTimeoutMs();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("socket_timeout_ms type is invalid");
        }
    }

    void validateProxyPassword() throws ConnectorValidationException {
        try {
            this.getProxyPassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_password type is invalid");
        }
    }

    void validateProxyUsername() throws ConnectorValidationException {
        try {
            this.getProxyUsername();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_username type is invalid");
        }
    }

    void validateProxyPort() throws ConnectorValidationException {
        try {
            this.getProxyPort();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_port type is invalid");
        }
    }

    void validateProxyHost() throws ConnectorValidationException {
        try {
            this.getProxyHost();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_host type is invalid");
        }
    }

    void validateProxyProtocol() throws ConnectorValidationException {
        try {
            this.getProxyProtocol();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("proxy_protocol type is invalid");
        }
    }

    void validateAuthPreemptive() throws ConnectorValidationException {
        try {
            this.getAuthPreemptive();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_preemptive type is invalid");
        }
    }

    void validateAuthRealm() throws ConnectorValidationException {
        try {
            this.getAuthRealm();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_realm type is invalid");
        }
    }

    void validateAuthPort() throws ConnectorValidationException {
        try {
            this.getAuthPort();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_port type is invalid");
        }
    }

    void validateAuthHost() throws ConnectorValidationException {
        try {
            this.getAuthHost();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_host type is invalid");
        }
    }

    void validateAuthPassword() throws ConnectorValidationException {
        try {
            this.getAuthPassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_password type is invalid");
        }
    }

    void validateAuthUsername() throws ConnectorValidationException {
        try {
            this.getAuthUsername();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("auth_basic_username type is invalid");
        }
    }

    void validateKeyStorePassword() throws ConnectorValidationException {
        try {
            this.getKeyStorePassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("key_store_password type is invalid");
        }
    }

    void validateKeyStoreFile() throws ConnectorValidationException {
        try {
            this.getKeyStoreFile();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("key_store_file type is invalid");
        }
    }

    void validateTrustStorePassword() throws ConnectorValidationException {
        try {
            this.getTrustStorePassword();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("trust_store_password type is invalid");
        }
    }

    void validateTrustStoreFile() throws ConnectorValidationException {
        try {
            this.getTrustStoreFile();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("trust_store_file type is invalid");
        }
    }

    void validateTLS() throws ConnectorValidationException {
        try {
            this.getTLS();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("TLS type is invalid");
        }
    }

    void validateIgnoreBody() throws ConnectorValidationException {
        try {
            this.getIgnoreBody();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("ignore_body type is invalid");
        }
    }

    void validateDoNotFollowRedirect() throws ConnectorValidationException {
        try {
            this.getDoNotFollowRedirect();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("do_not_follow_redirect type is invalid");
        }
    }

    void validateBody() throws ConnectorValidationException {
        if (this.hasBody()) {
            try {
                this.getBody();
            }
            catch (ClassCastException cce) {
                throw new ConnectorValidationException("body type is invalid");
            }
        }
    }

    void validateUrlHeaders() throws ConnectorValidationException {
        try {
            this.getUrlHeaders();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("urlHeaders type is invalid");
        }
    }

    void validateAddBonitaContextHeaders() throws ConnectorValidationException {
        try {
            this.getAddBonitaContextHeaders();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("add_bonita_context_headers type is invalid");
        }
    }

    void validateBonitaContextHeaders() throws ConnectorValidationException {
        try {
            this.getBonitaActivityInstanceIdHeader();
            this.getBonitaProcessInstanceIdHeader();
            this.getBonitaRootProcessInstanceIdHeader();
            this.getBonitaProcessDefinitionIdHeader();
            this.getBonitaTaskAssigneeIdHeader();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("one of bonita context headers type is invalid");
        }
    }

    void validateUrlCookies() throws ConnectorValidationException {
        try {
            this.getUrlCookies();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("urlCookies type is invalid");
        }
    }

    void validateCharset() throws ConnectorValidationException {
        try {
            this.getCharset();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("charset type is invalid");
        }
    }

    void validateContentType() throws ConnectorValidationException {
        try {
            this.getContentType();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("contentType type is invalid");
        }
    }

    void validateMethod() throws ConnectorValidationException {
        try {
            this.getMethod();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("method type is invalid");
        }
    }

    void validateUrl() throws ConnectorValidationException {
        try {
            this.getUrl();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("url type is invalid");
        }
    }

    void validateFailOnHttp5xx() throws ConnectorValidationException {
        try {
            this.getFailOnHttp5xx();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("fail_on_http_5xx type is invalid");
        }
    }

    void validateFailOnHttp4xx() throws ConnectorValidationException {
        try {
            this.getFailOnHttp4xx();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("fail_on_http_4xx type is invalid");
        }
    }

    void validateFailExceptionHttpCodes() throws ConnectorValidationException {
        try {
            for (String code : this.getFailExceptionHttpCodes()) {
                int statusCode = Integer.parseInt(code);
                if (statusCode >= 400 && statusCode <= 599) continue;
                throw new ConnectorValidationException("failure_exception_codes type is invalid");
            }
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new ConnectorValidationException("failure_exception_codes type is invalid");
        }
    }

    void validateRetryOnHttp5xx() throws ConnectorValidationException {
        try {
            this.getRetryOnHttp5xx();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("retry_on_http_5xxtype is invalid");
        }
    }

    void validateRetryAdditionalHttpCodes() throws ConnectorValidationException {
        try {
            for (String code : this.getRetryAdditionalHttpCodes()) {
                int statusCode = Integer.parseInt(code);
                if (statusCode >= 400 && statusCode <= 599) continue;
                throw new ConnectorValidationException("retry_additional_codes type is invalid");
            }
        }
        catch (ConnectorValidationException e) {
            throw e;
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new ConnectorValidationException("retry_additional_codes type is invalid");
        }
    }

    void validateMaximumBodyContentPrintedLogs() throws ConnectorValidationException {
        try {
            Integer maxBodyContentPrintedLogs = this.getMaximumBodyContentPrintedLogs();
            if (Optional.ofNullable(maxBodyContentPrintedLogs).orElse(0) < 0) {
                throw new ConnectorValidationException("max_body_content_printed must be a positive integer");
            }
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("max_body_content_printed type is invalid");
        }
    }

    void validateShowSensitiveHeadersInLogs() throws ConnectorValidationException {
        try {
            this.getShowSensitiveHeadersInLogs();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("sensitive_headers_printed type is invalid");
        }
    }

    void validateTrustCertificateStrategyInput() throws ConnectorValidationException {
        String trustParam = null;
        try {
            trustParam = (String)this.getInputParameter(TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER);
            if (trustParam != null && !trustParam.trim().isEmpty()) {
                TrustCertificateStrategy.valueOf(trustParam);
            }
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException(String.format("%s type is invalid", TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER));
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorValidationException(String.format("'%s' option is invalid for %s. Only one of %s is supported.", trustParam, TRUST_CERTIFICATE_STRATEGY_INPUT_PARAMETER, Arrays.toString((Object[])TrustCertificateStrategy.values())));
        }
    }

    void validateHostnameVerifierInput() throws ConnectorValidationException {
        try {
            String hostNameVerifierParam = (String)this.getInputParameter(HOSTNAME_VERIFIER_INPUT_PARAMETER);
            SSLVerifier.getSSLVerifierFromValue(hostNameVerifierParam);
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException(String.format("%s type is invalid", HOSTNAME_VERIFIER_INPUT_PARAMETER));
        }
    }

    void validateAutomaticProxyResolution() throws ConnectorValidationException {
        try {
            this.getAutomaticProxyResolution();
        }
        catch (ClassCastException cce) {
            throw new ConnectorValidationException("automatic_proxy_resolution type is invalid");
        }
    }

    public abstract boolean hasBody();
}

