/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.rest.utils;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyUtils {
    private static final Logger log = LoggerFactory.getLogger(ProxyUtils.class);
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";

    private ProxyUtils() {
    }

    public static Optional<InetSocketAddress> proxyAddress(URI uri) {
        return ProxyUtils.proxy(uri).map(Proxy::address).map(InetSocketAddress.class::cast);
    }

    public static Optional<Proxy> proxy(URI uri) {
        Proxy proxy = ProxySelector.getDefault().select(uri).get(0);
        log.debug("Using proxy {} for URI {}", (Object)proxy, (Object)uri);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return Optional.empty();
        }
        return Optional.of(proxy);
    }

    public static Optional<String> hostName(URI uri) {
        return ProxyUtils.proxyAddress(uri).map(InetSocketAddress::getHostName);
    }

    public static Optional<Integer> port(URI uri) {
        return ProxyUtils.proxyAddress(uri).map(InetSocketAddress::getPort);
    }
}

