/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.sap;

import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.bonitasoft.engine.connector.sap.SAPMonoDestinationDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPCallFunction
extends AbstractConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAPCallFunction.class);
    static final String MESSAGE_SERVER_TYPE = "MessageServer";
    static final String APPLICATION_SERVER_TYPE = "ApplicationServer";
    public static final String SERVER_TYPE = "serverType";
    public static final String CLIENT = "client";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String LANGUAGE = "language";
    public static final String HOST = "host";
    public static final String SYSTEM_NUMBER = "systemNumber";
    public static final String SYSTEM_ID = "systemId";
    public static final String GROUP_NAME = "groupName";
    public static final String DESTINATION_NAME = "destinationName";
    public static final String REPOSITORY = "repository";
    public static final String FUNCTION_NAME = "functionName";
    public static final String COMMIT_ON_SUCCESS = "commitOnSuccess";
    public static final String ROLLBACK_ON_FAILURE = "rollbackOnFailure";
    public static final String DESTINATION_DATA = "destinationData";
    public static final String INPUT_PARAMETERS = "inputParameters";
    public static final String OUTPUT_PARAMETERS = "outputParameters";
    public static final String HTML_OUTPUT = "htmlOutput";
    public static final String OUTPUT_RESULTS = "outputResults";
    private static final int EXPECTED_INPUT_COLUMN_NUMBER = 4;
    private static final List<String> INPUT_PARAMETER_TYPES = new ArrayList<String>();
    public static final String TABLE_INPUT = "table_input";
    public static final String INPUT_TABLE = "input_table";
    public static final String INPUT_STRUCTURE = "input_structure";
    public static final String INPUT_SINGLE = "input_single";
    private static final int EXPECTED_OUTPUT_COLUMN_NUMBER = 3;
    private static final List<String> OUTPUT_PARAMETER_TYPES = new ArrayList<String>();
    public static final String TABLE_OUTPUT = "table_output";
    public static final String OUTPUT_TABLE = "output_table";
    public static final String OUTPUT_STRUCTURE = "output_structure";
    public static final String OUTPUT_SINGLE = "output_single";
    private static final String COMMIT_FUNCTION_NAME = "BAPI_TRANSACTION_COMMIT";
    private JCoFunction function;
    private JCoDestination destination;
    private SAPMonoDestinationDataProvider destinationProvider;

    public void executeBusinessLogic() throws ConnectorException {
        JCoParameterList tableParameterList = this.fillJCOTableParameterList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO call function {} with JCoParameterList = {}", (Object)this.function.getName(), (Object)tableParameterList.toXML());
        }
        this.callJCOFunction();
        List<Serializable> results = this.fillBonitaResultWithJCOCallResult(tableParameterList);
        this.setOutputParameter(OUTPUT_RESULTS, results);
    }

    private void callJCOFunction() throws ConnectorException {
        try {
            this.destination = JCoDestinationManager.getDestination((String)this.destinationProvider.getDestinationName());
        }
        catch (JCoException e) {
            throw new ConnectorException("Failed to get destination", (Throwable)e);
        }
        long start = System.currentTimeMillis();
        try {
            this.function.execute(this.destination);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SAP JCO call function {} executed in {} ms.", (Object)this.function.getName(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (JCoException e) {
            throw new ConnectorException("Failed to execute function", (Throwable)e);
        }
        Boolean commitOnSuccess = (Boolean)this.getInputParameter(COMMIT_ON_SUCCESS, Boolean.valueOf(false));
        if (commitOnSuccess.booleanValue()) {
            try {
                this.commit();
            }
            catch (JCoException e) {
                throw new ConnectorException("Failed to commit the transaction.", (Throwable)e);
            }
        }
    }

    private void commit() throws JCoException {
        JCoFunction commitFunction = this.destination.getRepository().getFunction(COMMIT_FUNCTION_NAME);
        commitFunction.getImportParameterList().setValue("WAIT", (Object)"X");
        commitFunction.execute(this.destination);
    }

    private List<Serializable> fillBonitaResultWithJCOCallResult(JCoParameterList tableParameterList) {
        ArrayList<Serializable> results = new ArrayList<Serializable>();
        List outputParameters = (List)this.getInputParameter(OUTPUT_PARAMETERS);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO connector output paramters = {}", (Object)outputParameters);
        }
        if (outputParameters != null) {
            JCoParameterList outputParameterList = this.function.getExportParameterList();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SAP JCO function {} exported JCoParameterList = ", (Object)this.function.getName(), (Object)outputParameterList.toXML());
            }
            for (List row : outputParameters) {
                Object variableValue;
                String parameterType = (String)row.get(0);
                String tableName = (String)row.get(1);
                String xpath = (String)row.get(2);
                if (xpath.length() <= 0) continue;
                if (OUTPUT_STRUCTURE.equals(parameterType)) {
                    JCoStructure structure = outputParameterList.getStructure(tableName);
                    variableValue = structure.getString(xpath);
                } else {
                    variableValue = OUTPUT_SINGLE.equals(parameterType) ? outputParameterList.getString(xpath) : this.retrieveTableVariableValue(tableParameterList, outputParameterList, parameterType, tableName, xpath);
                }
                results.add((Serializable)variableValue);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO connector output result is = {} ", results);
        }
        return results;
    }

    private Serializable retrieveTableVariableValue(JCoParameterList tableParameterList, JCoParameterList outputParameterList, String parameterType, String tableName, String xpath) {
        JCoTable table = null;
        if (OUTPUT_TABLE.equals(parameterType)) {
            table = outputParameterList.getTable(tableName);
        } else if (TABLE_OUTPUT.equals(parameterType)) {
            table = tableParameterList.getTable(tableName);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (table != null) {
            boolean hasMoreElements;
            boolean bl = hasMoreElements = !table.isEmpty();
            while (hasMoreElements) {
                list.add(table.getString(xpath));
                if (table.isLastRow()) {
                    hasMoreElements = false;
                    continue;
                }
                table.nextRow();
            }
        }
        Serializable variableValue = list.isEmpty() ? null : (list.size() == 1 ? (Serializable)list.get(0) : list);
        return variableValue;
    }

    private JCoParameterList fillJCOTableParameterList() throws ConnectorException {
        JCoParameterList tableParameterList = this.function.getTableParameterList();
        List inputParameters = (List)this.getInputParameter(INPUT_PARAMETERS);
        if (inputParameters != null) {
            JCoParameterList inputParameterList = this.function.getImportParameterList();
            for (List column : inputParameters) {
                String parameterType = (String)column.get(0);
                String tableName = (String)column.get(1);
                String parameterName = (String)column.get(2);
                Object parameterValue = column.get(3);
                if (INPUT_STRUCTURE.equals(parameterType)) {
                    if (inputParameterList == null) {
                        throw new ConnectorException("input_structure is not a supported input type for parameter '" + parameterName + "' of table '" + tableName + "'");
                    }
                    JCoStructure structure = inputParameterList.getStructure(tableName);
                    if (structure == null) {
                        throw new ConnectorException("input_structure is not a supported input type for parameter '" + parameterName + "' of table '" + tableName + "'");
                    }
                    structure.setValue(parameterName, parameterValue);
                    continue;
                }
                if (INPUT_SINGLE.equals(parameterType)) {
                    if (inputParameterList == null) {
                        throw new ConnectorException("input_single is not a supported input type for parameter '" + parameterName + "' of table '" + tableName + "'");
                    }
                    inputParameterList.setValue(parameterName, parameterValue);
                    continue;
                }
                ArrayList list = new ArrayList();
                if (parameterValue instanceof List) {
                    list.addAll((List)parameterValue);
                } else {
                    list.add(parameterValue);
                }
                int rowSize = list.size();
                JCoTable table = null;
                if (INPUT_TABLE.equals(parameterType)) {
                    if (inputParameterList == null) {
                        throw new ConnectorException("input_table is not a supported input type for parameter '" + parameterName + "' of table '" + tableName + "'");
                    }
                    table = inputParameterList.getTable(tableName);
                } else if (TABLE_INPUT.equals(parameterType)) {
                    if (tableParameterList == null) {
                        throw new ConnectorException("table_input is not a supported input type for parameter '" + parameterName + "' of table '" + tableName + "'");
                    }
                    table = tableParameterList.getTable(tableName);
                }
                if (table == null) continue;
                table.firstRow();
                for (int rowNb = 0; rowNb < rowSize; ++rowNb) {
                    if (table.getNumRows() < rowNb + 1) {
                        table.appendRow();
                    }
                    table.setValue(parameterName, list.get(rowNb));
                    table.nextRow();
                }
            }
        }
        return tableParameterList;
    }

    public void validateInputParameters() throws ConnectorValidationException {
        this.checkParameterIsStringAndIsNotNull(FUNCTION_NAME);
        this.checkParameterIsStringAndIsNotNull(CLIENT);
        this.checkParameterIsStringAndIsNotNull(USER);
        this.checkParameterIsStringAndIsNotNull(PASSWORD);
        this.checkParameterIsStringAndIsNotNull(LANGUAGE);
        this.checkParameterIsStringAndIsNotNull(HOST);
        Object inputServerTypeParameterValue = this.getInputParameter(SERVER_TYPE);
        if (APPLICATION_SERVER_TYPE.equals(inputServerTypeParameterValue)) {
            this.checkIsNotNull(SYSTEM_NUMBER);
        } else if (MESSAGE_SERVER_TYPE.equals(inputServerTypeParameterValue)) {
            this.checkIsNotNull(GROUP_NAME);
            this.checkIsNotNull(SYSTEM_ID);
        }
        this.validateJCOInputParameter();
        this.validateJCOOutputPrameter();
    }

    private void validateJCOOutputPrameter() throws ConnectorValidationException {
        Object functionOutputParameters;
        Object outputParameter = this.getInputParameter(OUTPUT_PARAMETERS);
        if (outputParameter != null && !((functionOutputParameters = outputParameter) instanceof List)) {
            throw new ConnectorValidationException("parameter: outputParameters is specified but is not an instance of " + List.class.getName() + ".");
        }
        List outputParameters = (List)outputParameter;
        if (outputParameters != null) {
            int outputRowNb = 1;
            for (List row : outputParameters) {
                if (row.size() != 3) {
                    throw new ConnectorValidationException("Row number: " + outputRowNb + " has a wrong number of columns: " + row.size() + " (instead of 3).");
                }
                if (!OUTPUT_PARAMETER_TYPES.contains(row.get(0))) {
                    throw new ConnectorValidationException("Row number: " + outputRowNb + " has a wrong value for parameterType: " + (String)row.get(0) + " (instead of " + OUTPUT_PARAMETER_TYPES + ").");
                }
                ++outputRowNb;
            }
        }
    }

    private void validateJCOInputParameter() throws ConnectorValidationException {
        Object functionInputParameters;
        Object inputParameter = this.getInputParameter(INPUT_PARAMETERS);
        if (inputParameter != null && !((functionInputParameters = inputParameter) instanceof List)) {
            throw new ConnectorValidationException("parameter: inputParameters is specified but is not an instance of " + List.class.getName() + ".");
        }
        List inputParameters = (List)inputParameter;
        if (inputParameters != null) {
            int inputRowNb = 1;
            for (List row : inputParameters) {
                if (row.size() != 4) {
                    throw new ConnectorValidationException("Row number: " + inputRowNb + " has a wrong number of columns: " + row.size() + " (instead of 4).");
                }
                if (!INPUT_PARAMETER_TYPES.contains(row.get(0))) {
                    throw new ConnectorValidationException("Row number: " + inputRowNb + " has a wrong value for parameterType: " + row.get(0) + " (instead of " + INPUT_PARAMETER_TYPES + ").");
                }
                ++inputRowNb;
            }
        }
    }

    private String checkParameterIsStringAndIsNotNull(String parameterName) throws ConnectorValidationException {
        Object inputParameterValue = this.getInputParameter(parameterName);
        if (inputParameterValue == null) {
            throw new ConnectorValidationException("Mandatory parameter: " + parameterName + " is specified but has a null value (forbidden).");
        }
        if (!(inputParameterValue instanceof String)) {
            throw new ConnectorValidationException("Mandatory parameter: " + parameterName + " is specified but is not an instance of " + String.class.getName() + ".");
        }
        return (String)inputParameterValue;
    }

    private void checkIsNotNull(String key) throws ConnectorValidationException {
        if (this.getInputParameter(key) == null) {
            throw new ConnectorValidationException("Mandatory property: " + key + " is specified but has a null value (forbidden).");
        }
    }

    public void connect() throws ConnectorException {
        String destinationName = this.getInputParameter(DESTINATION_NAME).toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO Connecting to {} destination", (Object)destinationName);
        }
        Properties destinationProperties = this.createDestinationDataProperties(destinationName);
        try {
            this.destinationProvider = SAPMonoDestinationDataProvider.getInstance((String)destinationName);
        }
        catch (Exception e1) {
            throw new ConnectorException("Can't get a SAP Destination Provider", (Throwable)e1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO retrieved the DestinationDataProvider singleton: {}", (Object)this.destinationProvider);
        }
        this.destinationProvider.changeProperties(destinationProperties);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO DestinationDataProvider properties updated.");
        }
        JCoDestination destination = this.retrieveJCODestination(destinationName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO JCoDestination properties = {}", (Object)destination.getProperties().toString());
        }
        JCoRepository repository = this.retrieveJCORepository(destination);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO Repository = {}", (Object)repository);
        }
        String functionName = (String)this.getInputParameter(FUNCTION_NAME);
        try {
            this.function = repository.getFunctionTemplate(functionName).getFunction();
        }
        catch (JCoException e) {
            throw new ConnectorException((Throwable)e);
        }
        if (this.function == null) {
            throw new RuntimeException("Function " + functionName + " does not exist.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO Function = {}", (Object)this.function);
        }
        JCoContext.begin((JCoDestination)destination);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SAP JCO Context started for destination = {}", (Object)destination);
        }
    }

    private JCoRepository retrieveJCORepository(JCoDestination destination) throws ConnectorException {
        JCoRepository repository;
        try {
            repository = destination.getRepository();
        }
        catch (JCoException e) {
            throw new ConnectorException((Throwable)e);
        }
        return repository;
    }

    private JCoDestination retrieveJCODestination(String destinationName) throws ConnectorException {
        try {
            return JCoDestinationManager.getDestination((String)destinationName);
        }
        catch (JCoException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    Properties createDestinationDataProperties(String destinationName) {
        Properties destinationData = new Properties();
        destinationData.put("jco.client.client", this.getInputParameter(CLIENT));
        destinationData.put("jco.client.user", this.getInputParameter(USER));
        destinationData.put("jco.client.passwd", this.getInputParameter(PASSWORD));
        destinationData.put("jco.client.lang", this.getInputParameter(LANGUAGE));
        destinationData.put("jco.client.dest", destinationName);
        if (APPLICATION_SERVER_TYPE.equals(this.getInputParameter(SERVER_TYPE))) {
            destinationData.put("jco.client.ashost", this.getInputParameter(HOST));
            destinationData.put("jco.client.sysnr", this.getInputParameter(SYSTEM_NUMBER));
        } else {
            destinationData.put("jco.client.mshost", this.getInputParameter(HOST));
            destinationData.put("jco.client.r3name", this.getInputParameter(SYSTEM_ID));
            destinationData.put("jco.client.group", this.getInputParameter(GROUP_NAME));
        }
        List inputParameterDestinationData = (List)this.getInputParameter(DESTINATION_DATA);
        if (inputParameterDestinationData != null) {
            for (List list : inputParameterDestinationData) {
                if (list.size() < 2) continue;
                destinationData.put(list.get(0), list.get(1));
            }
        }
        return destinationData;
    }

    public void disconnect() throws ConnectorException {
        try {
            JCoContext.end((JCoDestination)this.destination);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SAP JCO Context ended for destination = {}", (Object)this.destination);
            }
        }
        catch (JCoException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    static {
        INPUT_PARAMETER_TYPES.add(TABLE_INPUT);
        INPUT_PARAMETER_TYPES.add(INPUT_TABLE);
        INPUT_PARAMETER_TYPES.add(INPUT_STRUCTURE);
        INPUT_PARAMETER_TYPES.add(INPUT_SINGLE);
        OUTPUT_PARAMETER_TYPES.add(TABLE_OUTPUT);
        OUTPUT_PARAMETER_TYPES.add(OUTPUT_TABLE);
        OUTPUT_PARAMETER_TYPES.add(OUTPUT_STRUCTURE);
        OUTPUT_PARAMETER_TYPES.add(OUTPUT_SINGLE);
    }

    public static enum SAPDestinationType {
        APPLICATION_SERVER,
        MESSAGE_SERVER;

    }
}

