/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.shell;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Logger;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class ShellConnector
extends AbstractConnector {
    private static final String INTERPRETER = "interpreter";
    private static final String PARAMETER = "parameter";
    private static final String SCRIPT = "script";
    private static final Logger logger = Logger.getLogger(ShellConnector.class.getName());

    public Object getExitStatus() {
        return this.getOutputParameters().get("exitStatus");
    }

    public Object getResult() {
        return this.getOutputParameters().get("result");
    }

    public void validateInputParameters() throws ConnectorValidationException {
        String shell;
        String parameter;
        ArrayList<String> errors = new ArrayList<String>();
        String interpreter = (String)this.getInputParameter(INTERPRETER);
        if (ShellConnector.isNullOrEmpty(interpreter)) {
            errors.add("interpreter cannot be empty!");
        }
        if (ShellConnector.isNullOrEmpty(parameter = (String)this.getInputParameter(PARAMETER))) {
            errors.add("parameter cannot be empty!");
        }
        if (ShellConnector.isNullOrEmpty(shell = (String)this.getInputParameter(SCRIPT))) {
            errors.add("script cannot be empty!");
        }
        if (!errors.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, errors);
        }
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    protected void executeBusinessLogic() throws ConnectorException {
        String interpreterInput = this.getParameter(INTERPRETER);
        String parameterInput = this.getParameter(PARAMETER);
        String scriptInput = this.getParameter(SCRIPT);
        Process process = null;
        try {
            File script = this.createExecutableScript(scriptInput);
            process = this.runScript(interpreterInput, parameterInput, script);
            String processOutput = this.consumeProcessOutput(process);
            this.setOutputParameter("result", processOutput);
            this.setOutputParameter("exitStatus", process.waitFor());
            this.cleanUp(script);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e.getCause());
        }
        finally {
            Optional.ofNullable(process).ifPresent(Process::destroy);
        }
    }

    private void cleanUp(File script) throws IOException {
        try {
            Files.delete(script.toPath());
        }
        catch (IOException e) {
            logger.severe(() -> String.format("'%s' has not been cleaned after connector execution.", script.getAbsolutePath()));
            throw e;
        }
    }

    private String getParameter(String parameterName) {
        String value = (String)this.getInputParameter(parameterName);
        logger.info(() -> String.format("%s: %s", parameterName, value));
        return value;
    }

    private File createExecutableScript(String scriptInput) throws IOException {
        File tmpFile = File.createTempFile(SCRIPT, this.getExtension());
        if (tmpFile.setExecutable(true)) {
            tmpFile.deleteOnExit();
            try (FileWriter fw = new FileWriter(tmpFile);){
                fw.write(scriptInput);
            }
            return tmpFile;
        }
        throw new IOException(String.format("An error occured while trying to make the file '%s' executable. Check your permissions.", tmpFile.getAbsolutePath()));
    }

    private String getExtension() {
        String interpreter = (String)this.getInputParameter(INTERPRETER);
        if (interpreter.contains("cmd")) {
            return ".bat";
        }
        if (interpreter.contains("powershell")) {
            return ".ps1";
        }
        if (interpreter.contains("sh")) {
            return ".sh";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process runScript(String interpreterInput, String parameterInput, File script) throws IOException {
        String[] args = new String[]{interpreterInput, parameterInput, script.getCanonicalPath()};
        Process process = null;
        try {
            Process process2 = process = new ProcessBuilder(args).redirectErrorStream(true).start();
            return process2;
        }
        finally {
            if (process != null) {
                ShellConnector.closeQuietly(process.getOutputStream());
                ShellConnector.closeQuietly(process.getErrorStream());
            }
        }
    }

    private String consumeProcessOutput(Process process) throws IOException {
        try (InputStream processInputStream = process.getInputStream();){
            String string;
            try (BufferedReader scriptOutputReader = new BufferedReader(new InputStreamReader(processInputStream));){
                StringBuilder builder = new StringBuilder();
                String line = scriptOutputReader.readLine();
                String lineSep = System.getProperty("line.separator");
                while (line != null) {
                    builder.append(line);
                    builder.append(lineSep);
                    line = scriptOutputReader.readLine();
                }
                string = builder.toString();
            }
            return string;
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.warning("Unable to close " + e.getMessage());
            }
        }
    }
}

