/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;

public class CacheFilter
extends ExcludingPatternFilter {
    public static final String ALWAYS_CACHING = "alwaysCaching";
    public static final String NO_CUSTOMPAGE_CACHE = "noCacheCustomPage";
    protected static final String CACHE_FILTER_EXCLUDED_RESOURCES_PATTERN = "^/(bonita/)?(apps/.+/$)|(portal/resource/.+/content/$)|(portal/custom-page/.+/$)|(portal/custom-page/API/)";
    protected Map<String, String> paramMap = new HashMap<String, String>();
    private final String DURATION = "duration";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = filterConfig.getInitParameter(name);
            this.paramMap.put(name, value);
        }
    }

    @Override
    public String getDefaultExcludedPages() {
        return CACHE_FILTER_EXCLUDED_RESOURCES_PATTERN;
    }

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this.setResponseHeader(res);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    @Override
    public void excludePatternFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private void setResponseHeader(HttpServletResponse response) {
        Integer duration = Integer.valueOf(this.paramMap.get("duration"));
        boolean alwaysCaching = Boolean.parseBoolean(this.paramMap.get(ALWAYS_CACHING));
        boolean noCustomPageCache = Boolean.parseBoolean(System.getProperty(NO_CUSTOMPAGE_CACHE));
        if (!noCustomPageCache || alwaysCaching) {
            response.setHeader("Cache-Control", "max-age=" + duration);
        } else {
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
        }
    }
}

