/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.filter;

import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLExcludePattern {
    public final Pattern excludePattern;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)URLExcludePattern.class.getName());

    public URLExcludePattern(FilterConfig filterConfig, String defaultExcludePattern) {
        String processedDefaultExcludePattern;
        String contextPath = filterConfig.getServletContext().getContextPath();
        if (contextPath.length() > 0 && !contextPath.equals("/bonita")) {
            String webappName = contextPath.substring(1);
            processedDefaultExcludePattern = defaultExcludePattern.replace("bonita", webappName);
        } else {
            processedDefaultExcludePattern = defaultExcludePattern;
        }
        String configExcludePattern = filterConfig.getInitParameter("excludePattern");
        this.excludePattern = this.compilePattern(StringUtils.defaultString((String)configExcludePattern, (String)processedDefaultExcludePattern));
    }

    protected Pattern compilePattern(String stringPattern) {
        if (StringUtils.isNotBlank((CharSequence)stringPattern)) {
            try {
                return Pattern.compile(stringPattern);
            }
            catch (Exception e) {
                LOGGER.error("impossible to create pattern from [ {} ]  : ", (Object)stringPattern, (Object)e);
            }
        }
        return null;
    }

    public boolean matchExcludePatterns(String url) {
        try {
            boolean isExcluded;
            if (this.getExcludePattern() == null) {
                isExcluded = false;
            } else {
                String path = new URL(url).getPath();
                String normalizedPath = new URI(url).normalize().getPath();
                boolean bl = isExcluded = this.getExcludePattern().matcher(path).find() && this.getExcludePattern().matcher(normalizedPath).find();
            }
            if (LOGGER.isDebugEnabled()) {
                if (isExcluded) {
                    LOGGER.debug(" Exclude pattern match with this url: {}", (Object)url);
                } else {
                    LOGGER.debug(" Exclude pattern does not match with this url: {}", (Object)url);
                }
            }
            return isExcluded;
        }
        catch (Exception e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("impossible to get URL from given input [" + url + "]:" + e);
            }
            return this.getExcludePattern().matcher(url).find();
        }
    }

    public Pattern getExcludePattern() {
        return this.excludePattern;
    }
}

