/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.form;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedHumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.HumanTaskInstance;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFormService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessFormService.class.getName());

    public String getProcessPath(APISession apiSession, long processDefinitionId) throws BonitaException, UnsupportedEncodingException {
        ProcessDeploymentInfo processDeploymentInfo = this.getProcessAPI(apiSession).getProcessDeploymentInfo(processDefinitionId);
        return this.encodePathSegment(processDeploymentInfo.getName()) + "/" + this.encodePathSegment(processDeploymentInfo.getVersion());
    }

    public String encodePathSegment(String stringToEncode) throws UnsupportedEncodingException {
        return URLEncoder.encode(stringToEncode, StandardCharsets.UTF_8).replaceAll("\\+", "%20").replaceAll("%2F", "/").replaceAll("%2B", "+");
    }

    public long getProcessDefinitionId(APISession apiSession, String processName, String processVersion) throws BonitaException {
        block3: {
            if (processName != null && processVersion != null) {
                try {
                    return this.getProcessAPI(apiSession).getProcessDefinitionId(processName, processVersion);
                }
                catch (ProcessDefinitionNotFoundException e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Wrong parameters for process name and version", (Throwable)e);
                }
            }
        }
        return -1L;
    }

    public long getTaskInstanceId(APISession apiSession, long processInstanceId, String taskName, long userId) throws BonitaException {
        ProcessAPI processAPI = this.getProcessAPI(apiSession);
        long ensuredUserId = userId != -1L ? userId : apiSession.getUserId();
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 1);
        searchOptionsBuilder.filter("parentContainerId", (Serializable)Long.valueOf(processInstanceId));
        searchOptionsBuilder.filter("name", (Serializable)((Object)taskName));
        SearchResult searchMyAvailableHumanTasks = processAPI.searchMyAvailableHumanTasks(ensuredUserId, searchOptionsBuilder.done());
        if (searchMyAvailableHumanTasks.getCount() > 0L) {
            return ((HumanTaskInstance)searchMyAvailableHumanTasks.getResult().get(0)).getId();
        }
        SearchOptionsBuilder archivedSearchOptionsBuilder = new SearchOptionsBuilder(0, 1);
        archivedSearchOptionsBuilder.filter("assigneeId", (Serializable)Long.valueOf(ensuredUserId));
        archivedSearchOptionsBuilder.filter("parentProcessInstanceId", (Serializable)Long.valueOf(processInstanceId));
        archivedSearchOptionsBuilder.filter("name", (Serializable)((Object)taskName));
        SearchResult searchArchivedHumanTasks = processAPI.searchArchivedHumanTasks(archivedSearchOptionsBuilder.done());
        if (searchArchivedHumanTasks.getCount() > 0L) {
            return ((ArchivedHumanTaskInstance)searchArchivedHumanTasks.getResult().get(0)).getSourceObjectId();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Could not find task available with name " + taskName + " for process instance " + processInstanceId);
        }
        throw new ActivityInstanceNotFoundException(-1L);
    }

    public String getTaskName(APISession apiSession, long taskInstanceId) throws BonitaException {
        if (taskInstanceId != -1L) {
            ProcessAPI processAPI = this.getProcessAPI(apiSession);
            try {
                ActivityInstance activity = processAPI.getActivityInstance(taskInstanceId);
                return activity.getName();
            }
            catch (ActivityInstanceNotFoundException e) {
                ArchivedActivityInstance activity = processAPI.getArchivedActivityInstance(taskInstanceId);
                return activity.getName();
            }
        }
        return null;
    }

    public long ensureProcessDefinitionId(APISession apiSession, long processDefinitionId, long processInstanceId, long taskInstanceId) throws BonitaException {
        if (processDefinitionId != -1L) {
            return processDefinitionId;
        }
        if (processInstanceId != -1L) {
            return this.getProcessDefinitionIdFromProcessInstanceId(apiSession, processInstanceId);
        }
        return this.getProcessDefinitionIdFromTaskId(apiSession, taskInstanceId);
    }

    protected long getProcessDefinitionIdFromTaskId(APISession apiSession, long taskInstanceId) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, ActivityInstanceNotFoundException {
        ProcessAPI processAPI = this.getProcessAPI(apiSession);
        try {
            ActivityInstance activity = processAPI.getActivityInstance(taskInstanceId);
            return activity.getProcessDefinitionId();
        }
        catch (ActivityInstanceNotFoundException e) {
            ArchivedActivityInstance activity = processAPI.getArchivedActivityInstance(taskInstanceId);
            return activity.getProcessDefinitionId();
        }
    }

    protected long getProcessDefinitionIdFromProcessInstanceId(APISession apiSession, long processInstanceId) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, ArchivedProcessInstanceNotFoundException {
        ProcessAPI processAPI = this.getProcessAPI(apiSession);
        try {
            ProcessInstance processInstance = processAPI.getProcessInstance(processInstanceId);
            return processInstance.getProcessDefinitionId();
        }
        catch (ProcessInstanceNotFoundException e) {
            SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 1);
            searchOptionsBuilder.filter("sourceObjectId", (Serializable)Long.valueOf(processInstanceId));
            searchOptionsBuilder.sort("archiveDate", Order.ASC);
            SearchResult searchArchivedProcessInstances = null;
            try {
                searchArchivedProcessInstances = processAPI.searchArchivedProcessInstancesInAllStates(searchOptionsBuilder.done());
            }
            catch (SearchException se) {
                throw new ArchivedProcessInstanceNotFoundException((Throwable)se);
            }
            if (searchArchivedProcessInstances != null && searchArchivedProcessInstances.getCount() > 0L) {
                return ((ArchivedProcessInstance)searchArchivedProcessInstances.getResult().get(0)).getProcessDefinitionId();
            }
            throw new ArchivedProcessInstanceNotFoundException(processInstanceId);
        }
    }

    protected ProcessAPI getProcessAPI(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProcessAPI((APISession)apiSession);
    }
}

