/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;

public class PortalCookies {
    public void addCSRFTokenCookieToResponse(HttpServletRequest request, HttpServletResponse res, Object apiTokenFromClient) {
        String defaultCookiePath = StringUtils.isEmpty((CharSequence)request.getContextPath()) ? "/" : request.getContextPath();
        String path = System.getProperty("bonita.csrf.cookie.path", defaultCookiePath);
        this.invalidatePreviousCSRFTokenCookie(request, res, path);
        Cookie csrfCookie = new Cookie("X-Bonita-API-Token", apiTokenFromClient.toString());
        csrfCookie.setPath(path);
        csrfCookie.setSecure(this.isCSRFTokenCookieSecure());
        res.addCookie(csrfCookie);
    }

    private void invalidatePreviousCSRFTokenCookie(HttpServletRequest request, HttpServletResponse res, String path) {
        Cookie cookie = this.getCookie(request, "X-Bonita-API-Token");
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setValue("");
            res.addCookie(cookie);
            this.invalidateRootCookie(res, cookie, path);
        }
    }

    public void invalidateRootCookie(HttpServletResponse res, Cookie cookie, String path) {
        if (!"/".equals(path)) {
            Cookie rootCookie = (Cookie)cookie.clone();
            rootCookie.setPath("/");
            res.addCookie(rootCookie);
        }
    }

    public boolean isCSRFTokenCookieSecure() {
        return PropertiesFactory.getSecurityProperties().isCSRFTokenCookieSecure();
    }

    public Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }
}

