/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerFactory;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerNotFoundException;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.LoginFailedException;
import org.bonitasoft.console.common.server.login.credentials.UserLogger;
import org.bonitasoft.console.common.server.login.servlet.URLProtector;
import org.bonitasoft.console.common.server.login.utils.LoginUrl;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlBuilder;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlHandler;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutServlet
extends HttpServlet {
    private static final long serialVersionUID = 739607235407639011L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LogoutServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logout(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logout(request, response);
    }

    protected void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HttpServletRequestAccessor requestAccessor = new HttpServletRequestAccessor(request);
        HttpSession session = requestAccessor.getHttpSession();
        APISession apiSession = requestAccessor.getApiSession();
        try {
            this.engineLogout(apiSession);
            SessionUtil.sessionLogout(session);
            if (RedirectUrlHandler.shouldRedirectAfterLogout(request)) {
                String loginPage = this.getURLToRedirectTo(requestAccessor);
                response.sendRedirect(loginPage);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while performing the logout", (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
    }

    protected AuthenticationManager getAuthenticationManager() throws ServletException {
        try {
            return AuthenticationManagerFactory.getAuthenticationManager();
        }
        catch (AuthenticationManagerNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected String getURLToRedirectTo(HttpServletRequestAccessor requestAccessor) throws ServletException {
        String redirectionPage;
        AuthenticationManager authenticationManager = this.getAuthenticationManager();
        HttpServletRequest request = requestAccessor.asHttpServletRequest();
        String redirectURL = this.createRedirectUrl(requestAccessor);
        String logoutPage = authenticationManager.getLogoutPageURL(requestAccessor, redirectURL);
        if (logoutPage != null) {
            redirectionPage = logoutPage;
        } else {
            String loginPageURLFromRequest = request.getParameter("loginUrl");
            if (loginPageURLFromRequest != null) {
                redirectionPage = this.sanitizeLoginPageUrl(loginPageURLFromRequest);
            } else {
                LoginUrl loginPageURL = new LoginUrl(authenticationManager, redirectURL, requestAccessor);
                redirectionPage = loginPageURL.getLocation();
            }
        }
        return redirectionPage;
    }

    protected String createRedirectUrl(HttpServletRequestAccessor requestAccessor) throws ServletException {
        return RedirectUrlHandler.retrieveRedirectUrl(requestAccessor, new String[0]);
    }

    protected String sanitizeLoginPageUrl(String loginURL) {
        return new RedirectUrlBuilder(new URLProtector().protectRedirectUrl(loginURL)).build().getUrl();
    }

    protected void engineLogout(APISession apiSession) throws LoginFailedException {
        if (apiSession != null) {
            this.getUserLogger().doLogout(apiSession);
        }
    }

    protected UserLogger getUserLogger() {
        return new UserLogger();
    }
}

